/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.bugfinder;

import com.lintyservices.sonar.plugins.vhdl.checks.helpers.VhdlCrossFileVerificLogCheck;
import com.lintyservices.yosys.objects.VerificLogItem;
import org.sonar.check.Rule;

@Rule(key="VHDL1069")
public class SignalOrVariableNotInitializedCheck
extends VhdlCrossFileVerificLogCheck {
    private static final String ERROR_MESSAGE = "'%s' should be explicitly assigned a value before being used.";

    @Override
    public final void retrieveIssues() {
        String message;
        for (VerificLogItem item : this.filteredItems("VHDL-1303")) {
            if (item.message().contains(": using initial value '") && item.message().split("'").length >= 5) {
                message = String.format(ERROR_MESSAGE, item.message().split("'")[3]);
            } else if (item.message().contains(": using initial value ") && item.message().split("'").length >= 3) {
                message = String.format(ERROR_MESSAGE, item.message().split("'")[1]);
            } else {
                message = item.message();
                this.logMessageCannotBeCustomized("VHDL1069", item);
            }
            this.issues().addPreciseIssue(item.location(), message);
        }
        for (VerificLogItem item : this.filteredItems("VHDL-1794")) {
            if (item.message().contains(": using initial value ") && item.message().split("'").length >= 3) {
                message = String.format(ERROR_MESSAGE, item.message().split("'")[1]);
            } else {
                message = item.message();
                this.logMessageCannotBeCustomized("VHDL1069", item);
            }
            this.issues().addPreciseIssue(item.location(), message);
        }
    }
}

