/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.bugfinder;

import com.lintyservices.sonar.plugins.bugfinder.SynthesizedObjectsManagerInterface;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderSynthesizedObjectsManagerAwareVisitor;
import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.linty.language.issues.IssueLocation;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.VhdlSynthesizedObjectsManager;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.VhdlBugFinderCheck;
import com.lintyservices.sonar.plugins.vhdl.parser.CaseGenerateStatementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ElsifGenerateStatementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ForGenerateStatementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.GenerateCaseStatementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.IfGenerateStatementTree;
import java.util.Comparator;
import java.util.HashSet;
import org.sonar.check.Rule;

@Rule(key="VHDL1052")
public class UnusedGenerateBlocksCheck
extends VhdlBugFinderCheck
implements BugFinderSynthesizedObjectsManagerAwareVisitor {
    private VhdlSynthesizedObjectsManager synthesizedObjectsManager;

    @Override
    public void setSynthesizedObjectsManager(SynthesizedObjectsManagerInterface synthesizedObjectsManager) {
        this.synthesizedObjectsManager = (VhdlSynthesizedObjectsManager)synthesizedObjectsManager;
    }

    @Override
    public void visitIfGenerateStatement(IfGenerateStatementTree tree) {
        HashSet<VhdlTree> unused = new HashSet<VhdlTree>();
        if (!this.synthesizedObjectsManager.isBlockSynthesized(this.context().file(), tree)) {
            unused.add(tree);
        }
        for (ElsifGenerateStatementTree elsifGenerateStatementTree : tree.elsifStatements()) {
            if (this.synthesizedObjectsManager.isBlockSynthesized(this.context().file(), elsifGenerateStatementTree)) continue;
            unused.add(elsifGenerateStatementTree);
        }
        if (tree.elseStatement() != null && !this.synthesizedObjectsManager.isBlockSynthesized(this.context().file(), tree.elseStatement())) {
            unused.add(tree.elseStatement());
        }
        if (!unused.isEmpty()) {
            this.addPreciseIssue(tree.label().identifier(), "Check if every non-synthesized if/elsif/else generate block can be reached with different configurations. If not, remove them.", unused.stream().map(u -> new HdlIssueLocation(u.firstToken(), "Not synthesized")).sorted(Comparator.comparingInt(IssueLocation::startLine)).toList());
        }
        super.visitIfGenerateStatement(tree);
    }

    @Override
    public void visitForGenerateStatement(ForGenerateStatementTree tree) {
        HashSet unused = new HashSet();
        if (!unused.isEmpty()) {
            this.addPreciseIssue(tree.beginStatementKeyword(), "Check if every non-synthesized case generate block can be reached with different configurations. If not, remove them.", unused.stream().map(u -> new HdlIssueLocation(u.firstToken(), "Not synthesized")).sorted(Comparator.comparingInt(IssueLocation::startLine)).toList());
        }
        super.visitForGenerateStatement(tree);
    }

    @Override
    public void visitCaseGenerateStatement(CaseGenerateStatementTree tree) {
        HashSet<GenerateCaseStatementTree> unused = new HashSet<GenerateCaseStatementTree>();
        for (GenerateCaseStatementTree caseStatement : tree.generateCaseStatements()) {
            if (this.synthesizedObjectsManager.isBlockSynthesized(this.context().file(), caseStatement)) continue;
            unused.add(caseStatement);
        }
        if (!unused.isEmpty()) {
            this.addPreciseIssue(tree.beginStatementKeyword(), "Check if every non-synthesized case generate block can be reached with different configurations. If not, remove them.", unused.stream().map(u -> new HdlIssueLocation(u.firstToken(), "Not synthesized")).sorted(Comparator.comparingInt(IssueLocation::startLine)).toList());
        }
        super.visitCaseGenerateStatement(tree);
    }
}

