/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.bugfinder;

import com.lintyservices.sonar.plugins.bugfinder.objects.clock.ClocksInterface;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderClocksAwareVisitor;
import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.linty.language.issues.PreciseIssue;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.clock.Clock;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.clock.ClockTransitionType;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.clock.Clocks;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.VhdlCrossFileBugFinderCheck;
import com.lintyservices.yosys.helpers.clock.ClockDirection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;

@Rule(key="VHDL1013")
public class UseEdgeFunctionCheck
extends VhdlCrossFileBugFinderCheck
implements BugFinderClocksAwareVisitor {
    private Set<Clock> clocks;

    @Override
    public void setClocks(ClocksInterface clocks) {
        this.clocks = ((Clocks)clocks).clocks();
    }

    @Override
    public final void retrieveIssues() {
        for (Clock clock : this.clocks) {
            this.issues().addPreciseIssues(clock.usage().stream().filter(u -> u.edgeTransitionDirection() != null).filter(u -> u.edgeTransitionType() != ClockTransitionType.EDGE).map(u -> new PreciseIssue(this, new HdlIssueLocation(u.file(), u.ifElsifConditionTree(), String.format("Use %s for '%s' clock signal edge transition.", u.edgeTransitionDirection().value().equals(ClockDirection.RISING.value()) ? "rising_edge" : "falling_edge", clock.name())), List.of(new HdlIssueLocation(clock.file(), clock.tree(), "Clock signal")))).collect(Collectors.toSet()));
        }
    }
}

