/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.parser.AssertionTree;
import com.lintyservices.sonar.plugins.vhdl.parser.AttributeNameTree;
import com.lintyservices.sonar.plugins.vhdl.parser.DesignFileTree;
import com.lintyservices.sonar.plugins.vhdl.parser.IdentifierTree;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="VHDL127")
public class AllowedAttributesCheck
extends VhdlDoubleDispatchVisitorCheck
implements HdlDesignerCheck {
    public static final String DEFAULT_ALLOWED_ATTRIBUTES = "event,high,left,length,low,range,right";
    private Set<String> allowedAttributesAsList = new HashSet<String>();
    @RuleProperty(key="allowedAttributes", description="Comma-separated list of allowed attributes", defaultValue="event,high,left,length,low,range,right")
    public String allowedAttributes = "event,high,left,length,low,range,right";

    @Override
    public void visitDesignFile(DesignFileTree tree) {
        if (this.context().isSynthesisFile()) {
            this.allowedAttributesAsList = Arrays.stream(this.allowedAttributes.split(",")).map(a -> a.trim().toLowerCase()).collect(Collectors.toSet());
            super.visitDesignFile(tree);
        }
    }

    @Override
    public void visitAssertion(AssertionTree tree) {
    }

    @Override
    public void visitAttributeName(AttributeNameTree tree) {
        IdentifierTree identifier = tree.designator().identifier();
        if (!this.allowedAttributesAsList.contains(identifier.text().toLowerCase())) {
            this.addPreciseIssue(identifier, "Remove the usage of this forbidden attribute.");
        }
        super.visitAttributeName(tree);
    }
}

