/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.parser.DesignFileTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SelectedNameTree;
import com.lintyservices.sonar.plugins.vhdl.parser.UseClauseTree;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="VHDL153")
public class AllowedLibrariesCheck
extends VhdlDoubleDispatchVisitorCheck
implements HdlDesignerCheck {
    private static final String DEFAULT_ALLOWED_LIBRARIES = "ieee.std_logic_1164,work";
    private Set<String> allowedLibrariesAsList;
    @RuleProperty(key="libraries", description="Comma-separated list of allowed libraries.\nA library could be:\n  - A global library such as 'ieee'\n  - A specific package such as 'ieee.std_logic_1164'\n  - A specific function in a package such as 'ieee.numeric_std.mod'", defaultValue="ieee.std_logic_1164,work")
    public String allowedLibraries = "ieee.std_logic_1164,work";

    @Override
    public void visitDesignFile(DesignFileTree tree) {
        this.allowedLibrariesAsList = Arrays.stream(this.allowedLibraries.split(",")).map(l -> l.trim().toLowerCase()).collect(Collectors.toSet());
        super.visitDesignFile(tree);
    }

    @Override
    public void visitUseClause(UseClauseTree tree) {
        for (SelectedNameTree library : tree.libraries().list().elements()) {
            if (!this.allowedLibrariesAsList.stream().noneMatch(l -> library.toString().toLowerCase().startsWith((String)l))) continue;
            this.addPreciseIssue(library, "Only use allowed libraries: " + this.allowedLibrariesAsList.stream().sorted().collect(Collectors.joining(", ")));
        }
        super.visitUseClause(tree);
    }
}

