/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.lexer.VhdlKeyword;
import com.lintyservices.sonar.plugins.vhdl.parser.ConstrainedArrayDefinitionTree;
import com.lintyservices.sonar.plugins.vhdl.parser.DiscreteRangeTree;
import com.lintyservices.sonar.plugins.vhdl.parser.RangeWithDirectionTree;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="VHDL164")
public class ArrayDirectionCheck
extends VhdlDoubleDispatchVisitorCheck
implements HdlDesignerCheck {
    private static final boolean USE_TO_DEFAULT = true;
    @RuleProperty(key="useTo", defaultValue="true", description="Set to true to check range directions in array definitions are 'TO'. When set to false, range directions 'DOWNTO' are checked.")
    public boolean useTo = true;

    @Override
    public void visitConstrainedArrayDefinition(ConstrainedArrayDefinitionTree tree) {
        List<DiscreteRangeTree> ranges = tree.indexConstraint().ranges();
        for (DiscreteRangeTree range : ranges) {
            RangeWithDirectionTree rangeTree;
            if (!range.is(VhdlTree.Kind.RANGE_WITH_DIRECTION) || (rangeTree = (RangeWithDirectionTree)range).direction().getGrammarRuleKey() != (this.useTo ? VhdlKeyword.DOWNTO : VhdlKeyword.TO)) continue;
            this.addPreciseIssue(rangeTree.direction(), "Use '" + String.valueOf(this.useTo ? VhdlKeyword.TO : VhdlKeyword.DOWNTO) + "' range direction instead.");
        }
        super.visitConstrainedArrayDefinition(tree);
    }
}

