/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlSyntaxToken;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.model.TreeImpl;
import com.lintyservices.sonar.plugins.vhdl.model.VhdlInternalSyntaxToken;
import com.lintyservices.sonar.plugins.vhdl.parser.ArchitectureBodyTree;
import com.lintyservices.sonar.plugins.vhdl.parser.IdentifierTree;
import com.lintyservices.sonar.plugins.vhdl.parser.MultipleDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ProcessDeclarativePartTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ProcessStatementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SubprogramBodyTree;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sonar.check.Rule;

@Rule(key="VHDL136")
public class BadCapitalizationCheck
extends VhdlDoubleDispatchVisitorCheck
implements HdlDesignerCheck {
    private static final String MESSAGE_BEGIN = "Wrong case according to declaration, rename to : ";
    private List<? extends VhdlTree> declarations = null;
    private List<? extends VhdlTree> statTree = new ArrayList<VhdlTree>();
    private Map<String, String> setDeclarations = new HashMap<String, String>();
    private List<VhdlTree> idList = new ArrayList<VhdlTree>();
    private String structName = null;
    private String reference;
    private List<VhdlTree> chld;

    @Override
    public void visitArchitectureBody(ArchitectureBodyTree tree) {
        this.init();
        this.statTree = tree.statements().statements();
        this.declarations = tree.declarativePart().blockDeclarativeItems();
        IdentifierTree structNameTree = tree.endIdentifier();
        if (structNameTree != null) {
            this.structName = structNameTree.text();
            this.chld = ((TreeImpl)((Object)tree)).getChildren();
            this.reference = this.chld.get(1).firstToken().text();
            if (this.structName.equalsIgnoreCase(this.reference) && !this.structName.equals(this.reference)) {
                this.addPreciseIssue(structNameTree, MESSAGE_BEGIN + this.reference + ".");
            }
        }
        this.checkDeclarations();
        super.visitArchitectureBody(tree);
    }

    @Override
    public void visitSubprogramBody(SubprogramBodyTree tree) {
        this.init();
        this.statTree = tree.statementPart().statements();
        this.declarations = tree.declarativePart();
        VhdlInternalSyntaxToken structNameToken = tree.designator();
        if (structNameToken != null) {
            this.structName = structNameToken.text();
            this.chld = ((TreeImpl)((Object)tree)).getChildren();
            this.reference = tree.specification().is(VhdlTree.Kind.SUBPROGRAM_SPECIFICATION_PROCEDURE) ? this.chld.get(0).lastToken().text() : ((TreeImpl)this.chld.get(0)).getChildren().get(1).firstToken().text();
            if (this.structName.equalsIgnoreCase(this.reference) && !this.structName.equals(this.reference)) {
                this.addPreciseIssue(structNameToken, MESSAGE_BEGIN + this.reference + ".");
            }
        }
        this.checkDeclarations();
        super.visitSubprogramBody(tree);
    }

    @Override
    public void visitProcessStatement(ProcessStatementTree tree) {
        this.init();
        this.statTree = tree.statementPart().statements().statements();
        ProcessDeclarativePartTree declT = tree.declarativePart();
        if (declT != null) {
            this.declarations = declT.items();
        }
        IdentifierTree idT = tree.label() != null ? tree.label().identifier() : null;
        IdentifierTree idT2 = tree.endLabel();
        if (idT != null && idT2 != null && idT.text().equalsIgnoreCase(idT2.text()) && !idT.text().equals(idT2.text())) {
            this.addPreciseIssue(idT2, MESSAGE_BEGIN + idT.text() + ".");
        }
        this.checkDeclarations();
        super.visitProcessStatement(tree);
    }

    private void init() {
        this.declarations = null;
        this.setDeclarations = new HashMap<String, String>();
        this.idList = new ArrayList<VhdlTree>();
    }

    private void checkDeclarations() {
        if (this.declarations != null) {
            int max = this.declarations.size();
            for (int i = 0; i < max; ++i) {
                VhdlTree declaration = this.declarations.get(i);
                List<Object> idTList = new ArrayList();
                switch (declaration.kind()) {
                    case SIGNAL_DECLARATION: 
                    case CONSTANT_DECLARATION: 
                    case VARIABLE_DECLARATION: {
                        idTList = ((MultipleDeclarationTree)declaration).identifiers();
                        break;
                    }
                }
                for (IdentifierTree id : idTList) {
                    this.setDeclarations.put(id.text().toLowerCase(), id.text());
                }
            }
        }
        this.statTree.forEach(t -> this.idList.addAll(t.allChildren(Set.of(VhdlTree.Kind.IDENTIFIER), Set.of(VhdlTree.Kind.FORMAL_PART))));
        this.checkTokensCase(this.idList, this.setDeclarations);
    }

    private void checkTokensCase(List<VhdlTree> idList, Map<String, String> setDeclarations) {
        for (VhdlTree id : idList) {
            String idTxt;
            VhdlSyntaxToken idToken = id.firstToken();
            if (idToken == null || !setDeclarations.containsKey((idTxt = idToken.text()).toLowerCase()) || setDeclarations.get(idTxt.toLowerCase()).equals(idTxt)) continue;
            this.addPreciseIssue(id, MESSAGE_BEGIN + setDeclarations.get(idTxt.toLowerCase()) + ".");
        }
    }
}

