/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.hdl.visitors.CrossFileCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.ComponentTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.EntityTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.TreeFileComparator;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.treefile.ComponentDeclarationTreeFileAwareVisitor;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.treefile.EntityTreeFileAwareVisitor;
import com.lintyservices.sonar.plugins.vhdl.parser.ComponentDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.EntityDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.IdentifierTree;
import com.lintyservices.sonar.plugins.vhdl.parser.PortClauseTree;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;

@Rule(key="VHDL156")
public class BadComponentPortCheck
extends VhdlDoubleDispatchVisitorCheck
implements CrossFileCheck,
EntityTreeFileAwareVisitor,
ComponentDeclarationTreeFileAwareVisitor {
    private Set<ComponentTreeFile> componentDeclarations = new HashSet<ComponentTreeFile>();
    private Map<String, Set<EntityTreeFile>> entities = new HashMap<String, Set<EntityTreeFile>>();

    @Override
    public void setComponentDeclarations(Set<ComponentTreeFile> componentDeclarations) {
        this.componentDeclarations = componentDeclarations;
    }

    @Override
    public void setEntities(Set<EntityTreeFile> entities) {
        this.entities = entities.stream().collect(Collectors.groupingBy(t -> ((EntityDeclarationTree)t.tree()).identifier().text(), Collectors.toSet()));
    }

    @Override
    public final void checkForIssues() {
        for (ComponentTreeFile componentTreeFile : this.componentDeclarations) {
            ComponentDeclarationTree component = (ComponentDeclarationTree)componentTreeFile.tree();
            EntityDeclarationTree entity = null;
            EntityTreeFile entityTreeFile = null;
            if (this.entities.get(component.identifier().text()) != null) {
                entityTreeFile = (EntityTreeFile)this.entities.get(component.identifier().text()).stream().sorted(new TreeFileComparator()).findFirst().get();
                entity = (EntityDeclarationTree)entityTreeFile.tree();
            }
            if (entity == null) continue;
            Set<String> componentPorts = this.componentPorts(component);
            Set<String> entityPorts = this.entityPorts(entity);
            HashSet<String> allPorts = new HashSet<String>();
            allPorts.addAll(componentPorts);
            allPorts.addAll(entityPorts);
            HashSet portsOnlyInEntity = new HashSet(allPorts);
            portsOnlyInEntity.removeAll(componentPorts);
            HashSet portsOnlyInComponent = new HashSet(allPorts);
            portsOnlyInComponent.removeAll(entityPorts);
            if (portsOnlyInComponent.isEmpty() && portsOnlyInEntity.isEmpty()) continue;
            StringBuilder issueMessage = new StringBuilder("Align component and related entity port names.");
            if (!portsOnlyInComponent.isEmpty()) {
                issueMessage.append(" Ports only defined in component: ").append(String.join((CharSequence)", ", portsOnlyInComponent)).append(".");
            }
            if (!portsOnlyInEntity.isEmpty()) {
                issueMessage.append(" Ports only defined in entity: ").append(String.join((CharSequence)", ", portsOnlyInEntity)).append(".");
            }
            this.issues().addPreciseIssue(componentTreeFile.file(), component.portClause() != null && component.portClause().portKeyword() != null ? component.portClause().portKeyword() : component.componentKeyword(), issueMessage.toString(), List.of(new HdlIssueLocation(entityTreeFile.file(), entity.header() != null && entity.header().portClause() != null ? entity.header().portClause() : entity.beginEntityKeyword(), "Related entity")));
        }
    }

    private Set<String> entityPorts(EntityDeclarationTree tree) {
        return tree.header() != null && tree.header().portClause() != null ? this.ports(tree.header().portClause()) : new HashSet<String>();
    }

    private Set<String> componentPorts(ComponentDeclarationTree tree) {
        return tree.portClause() != null ? this.ports(tree.portClause()) : new HashSet();
    }

    private Set<String> ports(PortClauseTree tree) {
        return tree.identifiers().stream().map(IdentifierTree::text).collect(Collectors.toSet());
    }
}

