/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.linty.language.issues.interfaces.IssueLocationInterface;
import com.lintyservices.sonar.plugins.linty.language.trees.Tree;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.GenericTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.SubtypeTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.TreeFileComparator;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.TypeTreeFile;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.treefile.Node;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.treefile.SubtypeTreeFileAwareVisitor;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.treefile.TypeAndSubtypeTreeFileUtils;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.treefile.TypeTreeFileAwareVisitor;
import com.lintyservices.sonar.plugins.vhdl.parser.ArrayTypeDefinitionTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ComponentDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.DesignFileTree;
import com.lintyservices.sonar.plugins.vhdl.parser.EntityDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.FullTypeDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.InterfaceDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.NameTree;
import com.lintyservices.sonar.plugins.vhdl.parser.RecordTypeDefinitionTree;
import com.lintyservices.utils.LintyException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="VHDL026")
public class BadPortTypeCheck
extends VhdlDoubleDispatchVisitorCheck
implements HdlDesignerCheck,
TypeTreeFileAwareVisitor,
SubtypeTreeFileAwareVisitor {
    public static final String TOP_LEVEL_ENTITY_DEFAULT_ALLOWED_TYPES = "std_logic,std_logic_vector";
    public static final String LOW_LEVEL_ENTITY_COMPONENT_DEFAULT_ALLOWED_TYPES = "std_logic,std_logic_vector";
    private Set<String> topLevelEntityAllowedTypesAsSet;
    private Set<String> lowLevelEntityComponentAllowedTypesAsSet;
    private String topLevelEntity;
    private List<TypeTreeFile> arrayTypes = new ArrayList<TypeTreeFile>();
    private List<TypeTreeFile> recordTypes = new ArrayList<TypeTreeFile>();
    private List<SubtypeTreeFile> subtypes = new ArrayList<SubtypeTreeFile>();
    @RuleProperty(key="topLevelEntityAllowedTypes", description="Comma separated list of allowed port types for top-level entities.", defaultValue="std_logic,std_logic_vector")
    public String topLevelEntityAllowedTypes = "std_logic,std_logic_vector";
    @RuleProperty(key="lowLevelEntityComponentAllowedTypes", description="Comma separated list of allowed port types for low-level entities/components.", defaultValue="std_logic,std_logic_vector")
    public String lowLevelEntityComponentAllowedTypes = "std_logic,std_logic_vector";

    @Override
    public void setTypes(Set<TypeTreeFile> types) {
        this.arrayTypes = types.stream().filter(t -> ((FullTypeDeclarationTree)t.tree()).typeDefinition() instanceof ArrayTypeDefinitionTree).sorted(new TreeFileComparator()).toList();
        this.recordTypes = types.stream().filter(t -> ((FullTypeDeclarationTree)t.tree()).typeDefinition() instanceof RecordTypeDefinitionTree).sorted(new TreeFileComparator()).toList();
    }

    @Override
    public void setSubtypes(Set<SubtypeTreeFile> subtypes) {
        this.subtypes = subtypes.stream().sorted(new TreeFileComparator()).toList();
    }

    @Override
    public void visitDesignFile(DesignFileTree tree) {
        if (this.context().topLevelModule() == null) {
            throw new LintyException("Check vhdl:VHDL026: sonar.hdl.topModule property is not set");
        }
        if (this.context().isSynthesisFile()) {
            this.topLevelEntityAllowedTypesAsSet = this.convertAllowedTypesFromCommaSeparatedStringToSet(this.topLevelEntityAllowedTypes);
            this.lowLevelEntityComponentAllowedTypesAsSet = this.convertAllowedTypesFromCommaSeparatedStringToSet(this.lowLevelEntityComponentAllowedTypes);
            this.topLevelEntity = this.context().topLevelModule();
            super.visitDesignFile(tree);
        }
    }

    @Override
    public void visitEntityDeclaration(EntityDeclarationTree tree) {
        if (this.isTopLevelEntity(tree)) {
            this.checkForIssuesOnTopLevelEntity(this.entityPorts(tree));
        } else {
            this.checkForIssuesOnLowLevelEntityComponent(this.entityPorts(tree));
        }
        super.visitEntityDeclaration(tree);
    }

    @Override
    public void visitComponentDeclaration(ComponentDeclarationTree tree) {
        this.checkForIssuesOnLowLevelEntityComponent(this.componentPorts(tree));
        super.visitComponentDeclaration(tree);
    }

    private void checkForIssuesOnTopLevelEntity(List<InterfaceDeclarationTree> ports) {
        for (InterfaceDeclarationTree port : ports) {
            if (port.type() == null || this.topLevelEntityAllowedTypesAsSet.contains(port.type().firstToken().text().toLowerCase())) continue;
            this.addPreciseIssue(port.type().typeName(), "Replace by one of the following allowed port types in top level entity: " + this.topLevelEntityAllowedTypesAsSet.stream().sorted().collect(Collectors.joining(", ")));
        }
    }

    private void checkForIssuesOnLowLevelEntityComponent(List<InterfaceDeclarationTree> ports) {
        for (InterfaceDeclarationTree port : ports) {
            if (port.type() == null) continue;
            Node<GenericTreeFile<NameTree>> node = new Node<GenericTreeFile<NameTree>>(new GenericTreeFile<NameTree>(port.type().typeName(), this.context().file()));
            TypeAndSubtypeTreeFileUtils.buildNameTree(node, this.arrayTypes, this.recordTypes, this.subtypes);
            this.checkPortType(node);
        }
    }

    private void checkPortType(Node<GenericTreeFile<NameTree>> node) {
        if (node.isLeaf()) {
            NameTree tree = (NameTree)node.getData().tree();
            String type = tree.firstToken().firstToken().text().toLowerCase();
            if (!this.lowLevelEntityComponentAllowedTypesAsSet.contains(type)) {
                this.addIssue(tree, null);
            }
        } else {
            for (Node<GenericTreeFile<NameTree>> leaf : node.getAllLeaves()) {
                NameTree tree = (NameTree)leaf.getData().tree();
                String type = tree.firstToken().firstToken().text().toLowerCase();
                if (this.lowLevelEntityComponentAllowedTypesAsSet.contains(type)) continue;
                Stack<Node<GenericTreeFile<NameTree>>> flowAsStack = new Stack<Node<GenericTreeFile<NameTree>>>();
                flowAsStack.push(leaf);
                flowAsStack.addAll(leaf.getAncestors());
                List<HdlIssueLocation> flowAsList = flowAsStack.stream().filter(a -> a.getParent() != null).map(a -> new HdlIssueLocation(((GenericTreeFile)a.getData()).file(), (Tree)((GenericTreeFile)a.getData()).tree(), "Related type")).toList();
                this.addIssue((VhdlTree)node.getData().tree(), List.of(flowAsList));
            }
        }
    }

    private void addIssue(VhdlTree tree, @Nullable List<List<? extends IssueLocationInterface>> flows) {
        String message = "Replace by one of the following allowed port types: " + this.lowLevelEntityComponentAllowedTypesAsSet.stream().sorted().collect(Collectors.joining(", ")) + ", subtype of those types, record of those types or array of those types.";
        if (flows != null) {
            this.addPreciseIssueWithFlows(tree, message, flows);
        } else {
            this.addPreciseIssue(tree, message);
        }
    }

    private boolean isTopLevelEntity(EntityDeclarationTree tree) {
        return this.topLevelEntity.equals(tree.identifier().text());
    }

    private List<InterfaceDeclarationTree> entityPorts(EntityDeclarationTree tree) {
        if (tree.header() != null && tree.header().portClause() != null) {
            return tree.header().portClause().ports().interfaces();
        }
        return new ArrayList<InterfaceDeclarationTree>();
    }

    private List<InterfaceDeclarationTree> componentPorts(ComponentDeclarationTree tree) {
        if (tree.portClause() != null) {
            return tree.portClause().ports().interfaces();
        }
        return new ArrayList<InterfaceDeclarationTree>();
    }

    private Set<String> convertAllowedTypesFromCommaSeparatedStringToSet(String allowedTypes) {
        return Arrays.stream(allowedTypes.split(",")).map(String::trim).map(String::toLowerCase).collect(Collectors.toSet());
    }
}

