/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.linty.language.checks.FreeHdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.parser.CaseStatementAlternativeTree;
import com.lintyservices.sonar.plugins.vhdl.parser.CaseStatementTree;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="VHDL240")
public class CaseTooManyCasesCheck
extends VhdlDoubleDispatchVisitorCheck
implements FreeHdlDesignerCheck {
    private static final int MAXIMUM_NUMBER_OF_CASES = 16;
    @RuleProperty(key="maxNumberOfCases", description="Maximum allowed number of cases.", defaultValue="16")
    public int maxNumberOfCases = 16;

    @Override
    public void visitCaseStatement(CaseStatementTree tree) {
        int count = 0;
        for (CaseStatementAlternativeTree alt : tree.alternatives()) {
            if (alt.choices() != null) {
                count += alt.choices().choices().size();
                continue;
            }
            ++count;
        }
        if (count > this.maxNumberOfCases) {
            this.addPreciseIssue(tree.beginStatementKeyword(), "Update design to split this case statement. Actual number of cases: " + count + ". Maximum number of allowed cases: " + this.maxNumberOfCases + ".");
        }
        super.visitCaseStatement(tree);
    }
}

