/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.linty.language.checks.FreeHdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ElsifStatementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.IfStatementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.LoopStatementTree;
import org.sonar.check.Rule;

@Rule(key="VHDL315")
public class EmptyConditionalBranchCheck
extends VhdlDoubleDispatchVisitorCheck
implements FreeHdlDesignerCheck {
    @Override
    public void visitIfStatement(IfStatementTree tree) {
        if (tree.thenStatements().statements().isEmpty()) {
            this.addPreciseIssue(tree.ifKeyword());
        }
        if (tree.elseStatements() != null && tree.elseStatements().statements().isEmpty()) {
            this.addPreciseIssue(tree.elseKeyword());
        }
        super.visitIfStatement(tree);
    }

    @Override
    public void visitElsifStatement(ElsifStatementTree tree) {
        if (tree.thenStatements().statements().isEmpty()) {
            this.addPreciseIssue(tree.ifKeyword());
        }
        super.visitElsifStatement(tree);
    }

    @Override
    public void visitWhileStatement(LoopStatementTree tree) {
        if (tree.statements().statements().isEmpty()) {
            this.addPreciseIssue(tree.loopKeyword());
        }
        super.visitWhileStatement(tree);
    }

    @Override
    public void visitForStatement(LoopStatementTree tree) {
        if (tree.statements().statements().isEmpty()) {
            this.addPreciseIssue(tree.loopKeyword());
        }
        super.visitForStatement(tree);
    }

    private void addPreciseIssue(VhdlTree tree) {
        this.addPreciseIssue(tree, "Implement this empty conditional branch or remove it.");
    }
}

