/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.parser.ArchitectureBodyTree;
import com.lintyservices.sonar.plugins.vhdl.parser.DesignFileTree;
import com.lintyservices.sonar.plugins.vhdl.parser.EntityDeclarationTree;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.sonar.check.Rule;

@Rule(key="VHDL203")
public class EntityArchitectureSeparateFilesCheck
extends VhdlDoubleDispatchVisitorCheck {
    private Set<EntityDeclarationTree> entities;
    private Set<ArchitectureBodyTree> architectures;

    @Override
    public void visitDesignFile(DesignFileTree tree) {
        this.entities = new HashSet<EntityDeclarationTree>();
        this.architectures = new HashSet<ArchitectureBodyTree>();
        super.visitDesignFile(tree);
        for (ArchitectureBodyTree architecture : this.architectures) {
            String relatedEntityName = architecture.entityName().text();
            Optional<EntityDeclarationTree> relatedEntity = this.entities.stream().filter(e -> e.identifier().text().equals(relatedEntityName)).findFirst();
            relatedEntity.ifPresent(e -> this.addPreciseIssue(architecture.identifier(), "Move this architecture to a dedicated file.", List.of(new HdlIssueLocation(e.identifier(), "Related entity"))));
        }
    }

    @Override
    public void visitEntityDeclaration(EntityDeclarationTree tree) {
        this.entities.add(tree);
        super.visitEntityDeclaration(tree);
    }

    @Override
    public void visitArchitectureBody(ArchitectureBodyTree tree) {
        this.architectures.add(tree);
        super.visitArchitectureBody(tree);
    }
}

