/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ArchitectureBodyTree;
import com.lintyservices.sonar.plugins.vhdl.parser.DesignFileTree;
import com.lintyservices.sonar.plugins.vhdl.parser.IdentifierTree;
import com.lintyservices.sonar.plugins.vhdl.parser.MultipleDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SubprogramBodyTree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.sonar.check.Rule;

@Rule(key="VHDL167")
public class ExternalSignalVariablePureFunctionCheck
extends VhdlDoubleDispatchVisitorCheck
implements HdlDesignerCheck {
    private boolean inFunction;
    private List<IdentifierTree> externalSignals;
    private List<IdentifierTree> externalVariables;

    @Override
    public void visitDesignFile(DesignFileTree tree) {
        this.inFunction = false;
        this.externalSignals = new ArrayList<IdentifierTree>();
        this.externalVariables = new ArrayList<IdentifierTree>();
        super.visitDesignFile(tree);
    }

    @Override
    public void visitArchitectureBody(ArchitectureBodyTree tree) {
        this.externalSignals.addAll(tree.declarativePart().blockDeclarativeItems().stream().filter(o -> o.is(VhdlTree.Kind.SIGNAL_DECLARATION)).map(MultipleDeclarationTree.class::cast).map(MultipleDeclarationTree::identifiers).flatMap(Collection::stream).toList());
        this.externalVariables.addAll(tree.declarativePart().blockDeclarativeItems().stream().filter(o -> o.is(VhdlTree.Kind.VARIABLE_DECLARATION)).map(MultipleDeclarationTree.class::cast).map(MultipleDeclarationTree::identifiers).flatMap(Collection::stream).toList());
        super.visitArchitectureBody(tree);
        this.externalSignals = new ArrayList<IdentifierTree>();
        this.externalVariables = new ArrayList<IdentifierTree>();
    }

    @Override
    public void visitSubprogramBody(SubprogramBodyTree tree) {
        if (tree.firstToken().text().equalsIgnoreCase("pure") || tree.firstToken().text().equalsIgnoreCase("function")) {
            this.inFunction = true;
        }
        super.visitSubprogramBody(tree);
        this.inFunction = false;
    }

    @Override
    public void visitIdentifier(IdentifierTree tree) {
        if (this.inFunction) {
            for (IdentifierTree externalSignal : this.externalSignals) {
                if (!externalSignal.text().equalsIgnoreCase(tree.text())) continue;
                this.addPreciseIssue(tree, "Remove this external signal that should not be used in pure function or mark this function as \"impure\".", List.of(new HdlIssueLocation(externalSignal, "External signal")));
                return;
            }
            for (IdentifierTree externalVariable : this.externalVariables) {
                if (!externalVariable.text().equalsIgnoreCase(tree.text())) continue;
                this.addPreciseIssue(tree, "Remove this external variable that should not be used in pure function or mark this function as \"impure\".", List.of(new HdlIssueLocation(externalVariable, "External variable")));
                return;
            }
        }
    }
}

