/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.parser.AssertionTree;
import com.lintyservices.sonar.plugins.vhdl.parser.AttributeNameTree;
import com.lintyservices.sonar.plugins.vhdl.parser.DesignFileTree;
import com.lintyservices.sonar.plugins.vhdl.parser.IdentifierTree;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="VHDL313")
public class ForbiddenAttributesCheck
extends VhdlDoubleDispatchVisitorCheck
implements HdlDesignerCheck {
    public static final String DEFAULT_FORBIDDEN_ATTRIBUTES = "";
    private Set<String> forbiddenAttributesAsList = new HashSet<String>();
    @RuleProperty(key="forbiddenAttributes", description="Comma-separated list of forbidden attributes", defaultValue="")
    public String forbiddenAttributes = "";

    @Override
    public void visitDesignFile(DesignFileTree tree) {
        if (this.context().isSynthesisFile()) {
            this.forbiddenAttributesAsList = Arrays.stream(this.forbiddenAttributes.split(",")).map(a -> a.trim().toLowerCase()).filter(a -> !a.isEmpty()).collect(Collectors.toSet());
            super.visitDesignFile(tree);
        }
    }

    @Override
    public void visitAssertion(AssertionTree tree) {
    }

    @Override
    public void visitAttributeName(AttributeNameTree tree) {
        IdentifierTree identifier = tree.designator().identifier();
        if (this.forbiddenAttributesAsList.contains(identifier.text().toLowerCase())) {
            this.addPreciseIssue(identifier, "Remove the usage of this forbidden attribute.");
        }
        super.visitAttributeName(tree);
    }
}

