/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.linty.language.issues.IssueLocation;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.model.VhdlInternalSyntaxToken;
import com.lintyservices.sonar.plugins.vhdl.parser.BinaryExpressionTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ConstantDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.DesignFileTree;
import com.lintyservices.sonar.plugins.vhdl.parser.FactorTree;
import com.lintyservices.sonar.plugins.vhdl.parser.GenericClauseTree;
import com.lintyservices.sonar.plugins.vhdl.parser.InterfaceDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.NumericLiteralTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ShiftExpressionTree;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;

@Rule(key="VHDL028")
public class ForbiddenOperatorCheck
extends VhdlDoubleDispatchVisitorCheck
implements HdlDesignerCheck {
    private static final Set<VhdlTree.Kind> OPERATORS_TO_VISIT = Set.of(VhdlTree.Kind.DIV, VhdlTree.Kind.MOD, VhdlTree.Kind.REM);
    private Set<String> constantsAndGenerics;

    @Override
    public void visitDesignFile(DesignFileTree tree) {
        if (this.context().isSynthesisFile()) {
            this.constantsAndGenerics = new HashSet<String>();
            super.visitDesignFile(tree);
        }
    }

    @Override
    public void visitConstantDeclaration(ConstantDeclarationTree tree) {
        this.constantsAndGenerics.addAll(tree.identifiers().stream().map(i -> i.text().toLowerCase()).collect(Collectors.toSet()));
        super.visitConstantDeclaration(tree);
    }

    @Override
    public void visitGenericClause(GenericClauseTree tree) {
        for (InterfaceDeclarationTree interfaceDeclaration : tree.generics().interfaces()) {
            this.constantsAndGenerics.addAll(interfaceDeclaration.identifiers().stream().map(i -> i.text().toLowerCase()).collect(Collectors.toSet()));
        }
        super.visitGenericClause(tree);
    }

    @Override
    public void visitShiftExpression(ShiftExpressionTree tree) {
        VhdlInternalSyntaxToken operator = (VhdlInternalSyntaxToken)tree.shiftOperator();
        if (!tree.hasAncestor(VhdlTree.Kind.CONSTANT_DECLARATION) && !tree.hasAncestor(VhdlTree.Kind.GENERIC_CLAUSE) && operator != null) {
            this.addPreciseIssue(operator, "Remove forbidden operator \"" + operator.text() + "\".");
        }
        super.visitShiftExpression(tree);
    }

    @Override
    public void visitFactor(FactorTree tree) {
        VhdlInternalSyntaxToken operator = (VhdlInternalSyntaxToken)tree.operator();
        if (!tree.hasAncestor(VhdlTree.Kind.CONSTANT_DECLARATION) && !tree.hasAncestor(VhdlTree.Kind.GENERIC_CLAUSE) && operator != null) {
            if ("abs".equalsIgnoreCase(operator.text())) {
                this.addPreciseIssue(operator, "Remove forbidden operator \"abs\".");
            } else if ("**".equals(operator.text()) && !"2".equals(tree.primary1().firstToken().text())) {
                this.addPreciseIssue(operator, "Left operand of \"**\" operator should be \"2\".", List.of(new IssueLocation(tree.primary1())));
            }
        }
        super.visitFactor(tree);
    }

    @Override
    public void visitBinaryExpression(BinaryExpressionTree tree) {
        if (!(tree.hasAncestor(VhdlTree.Kind.CONSTANT_DECLARATION) || tree.hasAncestor(VhdlTree.Kind.GENERIC_CLAUSE) || !OPERATORS_TO_VISIT.contains(tree.kind()) || this.constantsAndGenerics.contains(tree.rightOperand().firstToken().text().toLowerCase()) || this.powerOfTwo(tree.rightOperand()))) {
            this.addPreciseIssue(tree.operatorToken(), "Remove forbidden operator \"" + tree.operatorToken().text() + "\".");
        }
        super.visitBinaryExpression(tree);
    }

    private boolean powerOfTwo(VhdlTree tree) {
        if (tree.is(VhdlTree.Kind.FACTOR)) {
            tree = ((FactorTree)tree).primary1();
        }
        if (tree.is(VhdlTree.Kind.NUMERIC_LITERAL)) {
            try {
                long n = new BigDecimal(((NumericLiteralTree)tree).abstractLiteral().text()).toBigInteger().longValue();
                return n != 0L && (n & n - 1L) == 0L;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }
}

