/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.linty.language.trees.Tree;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.measures.visitors.ComplexityVisitor;
import com.lintyservices.sonar.plugins.vhdl.model.VhdlInternalSyntaxToken;
import com.lintyservices.sonar.plugins.vhdl.parser.SubprogramBodyTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SubprogramSpecificationFunctionTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SubprogramSpecificationProcedureTree;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="VHDL226")
public class FunctionProcedureComplexityCheck
extends VhdlDoubleDispatchVisitorCheck
implements HdlDesignerCheck {
    private static final int DEFAULT_MAX = 10;
    @RuleProperty(key="max", description="The maximum authorized complexity for function/procedure.", defaultValue="10")
    public int max = 10;

    @Override
    public void visitSubprogramBody(SubprogramBodyTree tree) {
        this.checkForIssue(tree);
    }

    private void checkForIssue(SubprogramBodyTree tree) {
        List<VhdlTree> complexityNodes = new ComplexityVisitor(tree).getComplexityNodes();
        if (complexityNodes.size() > this.max) {
            VhdlInternalSyntaxToken issueLocation = tree.specification().is(VhdlTree.Kind.SUBPROGRAM_SPECIFICATION_FUNCTION) ? ((SubprogramSpecificationFunctionTree)tree.specification()).functionKeyword() : ((SubprogramSpecificationProcedureTree)tree.specification()).procedureKeyword();
            this.addPreciseIssue(issueLocation, String.format("Refactor this %s to make it simpler to understand. Actual complexity (%d) is greater than the maximum authorized complexity (%d).", tree.specification().humanReadableKind(), complexityNodes.size(), this.max), complexityNodes.stream().map(n -> new HdlIssueLocation((Tree)n, "+1")).toList());
        }
    }
}

