/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.parser.CaseGenerateStatementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ForGenerateStatementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.IfGenerateStatementTree;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="VHDL214")
public class GenerateLabelCheck
extends VhdlDoubleDispatchVisitorCheck
implements HdlDesignerCheck {
    private static final boolean END_LABEL_PARAMETER_DEFAULT = true;
    private static final String END_LABEL_PARAMETER_DESCRIPTION = "Set to 'true' to check that end label is present. Set to 'false' otherwise.";
    @RuleProperty(key="mandatoryEndLabel", description="Set to 'true' to check that end label is present. Set to 'false' otherwise.", defaultValue="true")
    public boolean mandatoryEndLabel = true;

    @Override
    public void visitForGenerateStatement(ForGenerateStatementTree tree) {
        if (tree.label() == null) {
            this.addPreciseIssue(tree.beginStatementKeyword(), "Add a label.");
        }
        if (this.mandatoryEndLabel && tree.label() != null && tree.endLabel() == null) {
            this.addPreciseIssue(tree.endKeyword(), "Add an end label.");
        }
        if (tree.label() != null && tree.endLabel() != null && !tree.label().identifier().text().equals(tree.endLabel().text())) {
            this.addPreciseIssue(tree.endLabel(), "Rename this end label to match its begin label.", List.of(new HdlIssueLocation(tree.label(), "Begin label mismatch")));
        }
        super.visitForGenerateStatement(tree);
    }

    @Override
    public void visitCaseGenerateStatement(CaseGenerateStatementTree tree) {
        if (tree.label() == null) {
            this.addPreciseIssue(tree.beginStatementKeyword(), "Add a label.");
        }
        if (this.mandatoryEndLabel && tree.label() != null && tree.endLabel() == null) {
            this.addPreciseIssue(tree.endKeyword(), "Add an end label.");
        }
        if (tree.label() != null && tree.endLabel() != null && !tree.label().identifier().text().equals(tree.endLabel().text())) {
            this.addPreciseIssue(tree.endLabel(), "Rename this end label to match its begin label.", List.of(new HdlIssueLocation(tree.label(), "Begin label mismatch")));
        }
        super.visitCaseGenerateStatement(tree);
    }

    @Override
    public void visitIfGenerateStatement(IfGenerateStatementTree tree) {
        if (this.mandatoryEndLabel && tree.endLabel() == null) {
            this.addPreciseIssue(tree.endKeyword(), "Add an end label.");
        }
        if (tree.endLabel() != null && !tree.label().identifier().text().equals(tree.endLabel().identifier().text())) {
            this.addPreciseIssue(tree.endLabel().identifier(), "Rename this end label to match its begin label.", List.of(new HdlIssueLocation(tree.label().identifier(), "Begin label mismatch")));
        }
        super.visitIfGenerateStatement(tree);
    }
}

