/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.parser.DesignFileTree;
import com.lintyservices.sonar.plugins.vhdl.parser.IdentifierTree;
import com.lintyservices.sonar.plugins.vhdl.parser.PackageDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.PackageDeclarativeItemTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SignalDeclarationTree;
import org.sonar.check.Rule;

@Rule(key="VHDL229")
public class GlobalSignalCheck
extends VhdlDoubleDispatchVisitorCheck
implements HdlDesignerCheck {
    @Override
    public void visitDesignFile(DesignFileTree tree) {
        if (this.context().isSynthesisFile()) {
            super.visitDesignFile(tree);
        }
    }

    @Override
    public void visitPackageDeclaration(PackageDeclarationTree tree) {
        for (PackageDeclarativeItemTree declaration : tree.declarativeItems()) {
            if (!declaration.is(VhdlTree.Kind.SIGNAL_DECLARATION)) continue;
            SignalDeclarationTree signalDeclarationTree = (SignalDeclarationTree)declaration;
            for (IdentifierTree identifier : signalDeclarationTree.identifiers()) {
                this.addPreciseIssue(identifier, "Remove this global signal.");
            }
        }
        super.visitPackageDeclaration(tree);
    }
}

