/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.lexer.VhdlTokenType;
import com.lintyservices.sonar.plugins.vhdl.parser.DesignFileTree;
import com.lintyservices.sonar.plugins.vhdl.parser.NumericLiteralTree;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="VHDL023")
public class HardCodedNumericValueCheck
extends VhdlDoubleDispatchVisitorCheck
implements HdlDesignerCheck {
    private static final String DEFAULT_AUTHORIZED_VALUES = "0,1";
    private Set<BigDecimal> authorizedValuesAsSet;
    @RuleProperty(key="Authorized numeric values", description="Comma-separated list of authorized numeric values. Example: 0,1,2,1.0,2.0. Set to a single space to not exclude any value.", defaultValue="0,1")
    public String authorizedValues = "0,1";

    @Override
    public void visitDesignFile(DesignFileTree tree) {
        this.authorizedValuesAsSet = Arrays.stream(this.authorizedValues.split(",")).map(String::trim).map(BigDecimal::new).collect(Collectors.toSet());
        super.visitDesignFile(tree);
    }

    @Override
    public void visitNumericLiteral(NumericLiteralTree tree) {
        BigDecimal value;
        if (!(tree.abstractLiteral().getGrammarRuleKey().equals(VhdlTokenType.BASED_LITERAL) || this.authorizedValuesAsSet.contains(value = new BigDecimal(tree.abstractLiteral().text().replace("_", ""))) || tree.hasAncestor(VhdlTree.Kind.CONSTANT_DECLARATION) || tree.hasAncestor(VhdlTree.Kind.SIGNAL_DECLARATION) || tree.hasAncestor(VhdlTree.Kind.VARIABLE_DECLARATION) || tree.hasAncestor(VhdlTree.Kind.FULL_TYPE_DECLARATION) || tree.hasAncestor(VhdlTree.Kind.SUBTYPE_DECLARATION) || tree.hasAncestor(VhdlTree.Kind.INCOMPLETE_TYPE_DECLARATION) || tree.hasAncestor(VhdlTree.Kind.GENERIC_CLAUSE) || tree.hasAncestor(VhdlTree.Kind.GENERIC_MAP_ASPECT) || tree.hasAncestor(VhdlTree.Kind.PORT_CLAUSE) || tree.hasAncestor(VhdlTree.Kind.PORT_MAP_ASPECT))) {
            this.addPreciseIssue(tree.abstractLiteral(), "Replace this hard-coded numeric value by a reference to \"constant\" or \"generic\".");
        }
    }
}

