/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.lexer.VhdlTokenType;
import com.lintyservices.sonar.plugins.vhdl.model.VhdlInternalSyntaxToken;
import com.lintyservices.sonar.plugins.vhdl.parser.SimpleWaveformSignalAssignmentStatementTree;
import java.util.List;
import org.sonar.check.Rule;

@Rule(key="VHDL236")
public class HardCodedVectorAssignmentCheck
extends VhdlDoubleDispatchVisitorCheck
implements HdlDesignerCheck {
    @Override
    public void visitSimpleWaveformSignalAssignmentStatement(SimpleWaveformSignalAssignmentStatementTree tree) {
        List<VhdlInternalSyntaxToken> tokens = tree.waveform().allChildren(VhdlTree.Kind.TOKEN).stream().map(VhdlInternalSyntaxToken.class::cast).toList();
        if (tokens.size() == 1 && tokens.get(0).getGrammarRuleKey() == VhdlTokenType.STRING_LITERAL && tokens.get(0).text().length() > 3 && this.areAllCharactersTheSame(tokens.get(0).text().substring(1, tokens.get(0).text().length() - 1))) {
            this.addPreciseIssue(tokens.get(0), "Use \"OTHERS => '" + tokens.get(0).text().charAt(1) + "'\" instead.");
        }
        super.visitSimpleWaveformSignalAssignmentStatement(tree);
    }

    private boolean areAllCharactersTheSame(String s) {
        int n = s.length();
        for (int i = 1; i < n; ++i) {
            if (s.charAt(i) == s.charAt(0)) continue;
            return false;
        }
        return true;
    }
}

