/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.google.common.collect.ImmutableList;
import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.linty.language.checks.FreeHdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlSyntaxToken;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.model.SyntacticEquivalence;
import com.lintyservices.sonar.plugins.vhdl.parser.BinaryExpressionTree;
import com.lintyservices.sonar.plugins.vhdl.parser.RelationExpressionTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ShiftExpressionTree;
import java.util.List;
import org.sonar.check.Rule;

@Rule(key="VHDL027")
public class IdenticalOperandOnBinaryExpressionCheck
extends VhdlDoubleDispatchVisitorCheck
implements FreeHdlDesignerCheck {
    private static final String ERRSTRING = "Unknown tree class: ";
    private static final List<VhdlTree.Kind> SYMMETRIC_OPERATORS = ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(VhdlTree.Kind.AND)).add(VhdlTree.Kind.OR)).add(VhdlTree.Kind.NAND)).add(VhdlTree.Kind.NOR)).add(VhdlTree.Kind.XOR)).add(VhdlTree.Kind.XNOR)).add(VhdlTree.Kind.EQUAL)).add(VhdlTree.Kind.NOTEQ)).build();
    private static final List<VhdlTree.Kind> OPERATORS_TO_VISIT = ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(VhdlTree.Kind.AND)).add(VhdlTree.Kind.OR)).add(VhdlTree.Kind.NAND)).add(VhdlTree.Kind.NOR)).add(VhdlTree.Kind.XOR)).add(VhdlTree.Kind.XNOR)).add(VhdlTree.Kind.MINUS)).add(VhdlTree.Kind.DIV)).add(VhdlTree.Kind.MOD)).add(VhdlTree.Kind.REM)).add(VhdlTree.Kind.RELATION_EXPRESSION)).build();

    @Override
    public void visitRelationExpression(RelationExpressionTree tree) {
        this.visitExpression(tree);
        super.visitRelationExpression(tree);
    }

    @Override
    public void visitBinaryExpression(BinaryExpressionTree tree) {
        if (OPERATORS_TO_VISIT.contains(tree.kind())) {
            this.visitExpression(tree);
        }
        super.visitBinaryExpression(tree);
    }

    private void visitExpression(VhdlTree tree) {
        VhdlTree equivalentOperand = IdenticalOperandOnBinaryExpressionCheck.equivalentOperand(tree, IdenticalOperandOnBinaryExpressionCheck.rightOperand(tree));
        if (equivalentOperand != null) {
            this.addPreciseIssue(IdenticalOperandOnBinaryExpressionCheck.rightOperand(tree), "Identical sub-expressions on both sides of operator \"" + IdenticalOperandOnBinaryExpressionCheck.operatorToken(tree).text() + "\"", List.of(new HdlIssueLocation(equivalentOperand)));
        }
    }

    private static VhdlTree rightOperand(VhdlTree tree) {
        if (tree instanceof BinaryExpressionTree) {
            return ((BinaryExpressionTree)tree).rightOperand();
        }
        if (tree instanceof RelationExpressionTree) {
            return ((RelationExpressionTree)tree).shiftExpression2();
        }
        if (tree instanceof ShiftExpressionTree) {
            return ((ShiftExpressionTree)tree).simpleExpression2();
        }
        throw new RuntimeException(ERRSTRING + String.valueOf(tree.getClass()));
    }

    private static VhdlSyntaxToken operatorToken(VhdlTree tree) {
        if (tree instanceof BinaryExpressionTree) {
            return ((BinaryExpressionTree)tree).operatorToken();
        }
        if (tree instanceof RelationExpressionTree) {
            return ((RelationExpressionTree)tree).relationalOperator();
        }
        if (tree instanceof ShiftExpressionTree) {
            return ((ShiftExpressionTree)tree).shiftOperator();
        }
        throw new RuntimeException(ERRSTRING + String.valueOf(tree.getClass()));
    }

    private static VhdlTree equivalentOperand(VhdlTree tree, VhdlTree rightOperand) {
        if (tree instanceof BinaryExpressionTree) {
            return IdenticalOperandOnBinaryExpressionCheck.equivalentOperand(((BinaryExpressionTree)tree).leftOperand(), rightOperand, tree.kind());
        }
        if (tree instanceof RelationExpressionTree) {
            return IdenticalOperandOnBinaryExpressionCheck.equivalentOperand(((RelationExpressionTree)tree).shiftExpression1(), rightOperand, tree.kind());
        }
        if (tree instanceof ShiftExpressionTree) {
            return IdenticalOperandOnBinaryExpressionCheck.equivalentOperand(((ShiftExpressionTree)tree).simpleExpression1(), rightOperand, tree.kind());
        }
        throw new RuntimeException(ERRSTRING + String.valueOf(tree.getClass()));
    }

    private static VhdlTree equivalentOperand(VhdlTree left, VhdlTree right, VhdlTree.Kind binaryKind) {
        if (SyntacticEquivalence.areEquivalent(left, right)) {
            return left;
        }
        if (SYMMETRIC_OPERATORS.contains(binaryKind) && left.is(binaryKind)) {
            VhdlTree equivalent = IdenticalOperandOnBinaryExpressionCheck.equivalentOperand(((BinaryExpressionTree)left).leftOperand(), right, binaryKind);
            if (equivalent != null) {
                return equivalent;
            }
            return IdenticalOperandOnBinaryExpressionCheck.equivalentOperand(((BinaryExpressionTree)left).rightOperand(), right, binaryKind);
        }
        return null;
    }
}

