/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.lexer.VhdlKeyword;
import com.lintyservices.sonar.plugins.vhdl.parser.ConcurrentSignalAssignmentStatementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ConditionalWaveformElementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ProcessStatementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SelectedWaveformTree;
import java.util.List;
import org.sonar.check.Rule;

@Rule(key="VHDL140")
public class IncompleteConcurrentAssignmentCheck
extends VhdlDoubleDispatchVisitorCheck
implements HdlDesignerCheck {
    @Override
    public void visitProcessStatement(ProcessStatementTree tree) {
    }

    @Override
    public void visitConcurrentSignalAssignmentStatement(ConcurrentSignalAssignmentStatementTree tree) {
        if (tree.conditionalAssignment() != null) {
            List<ConditionalWaveformElementTree> waveList = tree.conditionalAssignment().waveforms().waveformList();
            if (waveList.get(waveList.size() - 1).condition() != null) {
                this.addPreciseIssue(this.context().file(), tree.conditionalAssignment().target(), "Add an \"else\" clause to complete this concurrent assignment.");
            }
        } else {
            List<SelectedWaveformTree> waveList = tree.selectedAssignment().waveforms();
            if (!waveList.get(waveList.size() - 1).lastToken().text().equalsIgnoreCase(VhdlKeyword.OTHERS.getValue())) {
                this.addPreciseIssue(this.context().file(), tree.selectedAssignment().target(), "Add a \"when others\" clause to complete this concurrent assignment.");
            }
        }
        super.visitConcurrentSignalAssignmentStatement(tree);
    }
}

