/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ComponentInstantiationStatementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.IndexedNameTree;
import com.lintyservices.sonar.plugins.vhdl.parser.NameTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SelectedNameTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SimpleNameTree;
import com.lintyservices.utils.LintyException;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="VHDL173")
public class InstantiationNamingConventionCheck
extends VhdlDoubleDispatchVisitorCheck
implements HdlDesignerCheck {
    private static final String DEFAULT_FORMAT = "^i_{COMPONENT_NAME}_[0-9]+$";
    @RuleProperty(key="format", description="Regular expression for the instance name to match.\nSee documentation at https://tinyurl.com/y37njdz2 and online regex checker at https://regex101.com\nAdd the following pattern into your regular expression to match the entity/component/configuration name: {COMPONENT_NAME}\n", type="REGULAR_EXPRESSION", defaultValue="^i_{COMPONENT_NAME}_[0-9]+$")
    public String format = "^i_{COMPONENT_NAME}_[0-9]+$";

    @Override
    public void visitComponentInstantiationStatement(ComponentInstantiationStatementTree tree) {
        String processedRegularExpression = this.format.replace("{COMPONENT_NAME}", this.getComponentName(tree.instantiatedUnit().name()));
        Pattern pattern = Pattern.compile(processedRegularExpression, 32);
        if (!pattern.matcher(tree.label().text()).matches()) {
            this.addPreciseIssue(tree.label(), String.format("Rename this instance to match the following regular expression: %s", processedRegularExpression));
        }
    }

    private String getComponentName(NameTree tree) {
        if (tree.is(VhdlTree.Kind.SIMPLE_NAME)) {
            return ((SimpleNameTree)tree).identifier().text();
        }
        if (tree.is(VhdlTree.Kind.INDEXED_NAME)) {
            return ((IndexedNameTree)tree).prefix().firstToken().text();
        }
        if (tree.is(VhdlTree.Kind.SELECTED_NAME)) {
            if (((SelectedNameTree)tree).suffix().is(VhdlTree.Kind.SIMPLE_NAME)) {
                return ((SelectedNameTree)tree).suffix().firstToken().text();
            }
            if (((SelectedNameTree)tree).suffix().is(VhdlTree.Kind.INDEXED_NAME)) {
                return ((IndexedNameTree)((SelectedNameTree)tree).suffix()).prefix().firstToken().text();
            }
            throw new LintyException("Rule VHDL173: Unsupported component type => " + String.valueOf(tree));
        }
        throw new LintyException("Rule VHDL173: Unsupported component type => " + String.valueOf(tree));
    }
}

