/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.lexer.VhdlTokenType;
import com.lintyservices.sonar.plugins.vhdl.model.VhdlInternalSyntaxToken;
import com.lintyservices.sonar.plugins.vhdl.parser.DesignFileTree;
import com.lintyservices.sonar.plugins.vhdl.parser.EntityDeclarationTree;
import java.util.regex.Pattern;
import org.sonar.check.Rule;

@Rule(key="VHDL224")
public class InternalTristateCheck
extends VhdlDoubleDispatchVisitorCheck
implements HdlDesignerCheck {
    @Override
    public void visitDesignFile(DesignFileTree tree) {
        if (this.context().isSynthesisFile() && !this.fileContainsTopLevelEntity(tree)) {
            super.visitDesignFile(tree);
        }
    }

    @Override
    public void visitInternalSyntaxToken(VhdlInternalSyntaxToken token) {
        if (token.getGrammarRuleKey() == VhdlTokenType.CHARACTER_LITERAL || token.getGrammarRuleKey() == VhdlTokenType.STRING_LITERAL) {
            String tokenWithoutQuotes = new StringBuilder(token.text()).deleteCharAt(token.text().length() - 1).deleteCharAt(0).toString();
            Pattern pattern = Pattern.compile("[10ZWLHUXzwlhux-]+", 32);
            if (pattern.matcher(tokenWithoutQuotes).matches() && tokenWithoutQuotes.toLowerCase().contains("z")) {
                this.addPreciseIssue(token, "Remove this internal tristate.");
            }
        }
        super.visitInternalSyntaxToken(token);
    }

    private boolean fileContainsTopLevelEntity(DesignFileTree tree) {
        for (EntityDeclarationTree entity : tree.entities()) {
            if (!entity.identifier().text().equalsIgnoreCase(this.context().topLevelModule())) continue;
            return true;
        }
        return false;
    }
}

