/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.SyntaxTrivia;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="VHDL231")
public class MatchKeywordsInCommentsCheck
extends VhdlDoubleDispatchVisitorCheck
implements HdlDesignerCheck {
    private static final String DEFAULT_KEYWORDS = "Requirement";
    @RuleProperty(key="keywords", description="Comma-separated list of keywords to match. It matches comments whatever the case of keywords.", defaultValue="Requirement")
    public String keywords = "Requirement";

    @Override
    public void visitInternalSyntaxTrivia(SyntaxTrivia trivia) {
        List<String> keywordsAsList = Arrays.stream(this.keywords.split(",")).map(String::trim).map(String::toLowerCase).toList();
        String comment = trivia.text();
        for (String keyword : keywordsAsList) {
            if (!StringUtils.containsIgnoreCase(comment, keyword) || MatchKeywordsInCommentsCheck.isLetterAround(comment, keyword)) continue;
            this.addPreciseIssue(trivia, "Match one of the keywords in comments.");
        }
    }

    private static boolean isLetterAround(String line, String pattern) {
        int start = StringUtils.indexOfIgnoreCase(line, pattern);
        int end = start + pattern.length();
        boolean pre = start > 0 && Character.isLetter(line.charAt(start - 1));
        boolean post = end < line.length() - 1 && Character.isLetter(line.charAt(end));
        return pre || post;
    }
}

