/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ArchitectureBodyTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ConcurrentSignalAssignmentStatementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ConcurrentStatementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.NameTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ProcessStatementPartTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ProcessStatementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SequentialStatementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SimpleWaveformSignalAssignmentStatementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.VariableAssignmentStatementTree;
import java.util.ArrayList;
import java.util.List;
import org.sonar.check.Rule;

@Rule(key="VHDL139")
public class MultipleConcurrentAssignmentCheck
extends VhdlDoubleDispatchVisitorCheck
implements HdlDesignerCheck {
    @Override
    public void visitArchitectureBody(ArchitectureBodyTree tree) {
        ArrayList<NameTree> assignedSignals = new ArrayList<NameTree>();
        ArrayList assignedSignalsAllProcs = new ArrayList();
        List<ConcurrentStatementTree> statList = tree.statements().statements();
        if (!statList.isEmpty()) {
            for (ConcurrentStatementTree stat : statList) {
                switch (stat.kind()) {
                    case CONCURRENT_SIGNAL_ASSIGNMENT_STATEMENT: {
                        NameTree sigName = null;
                        if (((ConcurrentSignalAssignmentStatementTree)stat).conditionalAssignment() != null && ((ConcurrentSignalAssignmentStatementTree)stat).conditionalAssignment().target().isName()) {
                            sigName = (NameTree)((ConcurrentSignalAssignmentStatementTree)stat).conditionalAssignment().target().target();
                        } else if (((ConcurrentSignalAssignmentStatementTree)stat).selectedAssignment() != null) {
                            NameTree nameTree = sigName = ((ConcurrentSignalAssignmentStatementTree)stat).selectedAssignment().target().isName() ? (NameTree)((ConcurrentSignalAssignmentStatementTree)stat).selectedAssignment().target().target() : null;
                        }
                        if (sigName != null && (assignedSignals.contains(sigName) || assignedSignalsAllProcs.contains(sigName))) {
                            this.addPreciseIssue(stat.firstToken(), "Multiple concurrent assignments of the signal " + sigName.firstToken().text() + ".");
                        }
                        assignedSignals.add(sigName);
                        break;
                    }
                    case PROCESS_STATEMENT: {
                        NameTree sigName;
                        ProcessStatementPartTree statListProc = ((ProcessStatementTree)stat).statementPart();
                        if (statListProc == null) break;
                        ArrayList<NameTree> assignedSignalsProc = new ArrayList<NameTree>();
                        for (SequentialStatementTree statProc : statListProc.statements().statements()) {
                            if (statProc.is(VhdlTree.Kind.SIMPLE_WAVEFORM_SIGNAL_ASSIGNMENT_STATEMENT)) {
                                NameTree nameTree = sigName = ((SimpleWaveformSignalAssignmentStatementTree)statProc).target().isName() ? (NameTree)((SimpleWaveformSignalAssignmentStatementTree)statProc).target().target() : null;
                                if (sigName != null && !assignedSignalsProc.contains(sigName) && assignedSignals.contains(sigName)) {
                                    this.addPreciseIssue(stat.firstToken(), "Multiple concurrent assignments of the signal " + sigName.firstToken().text() + ".");
                                }
                                assignedSignals.add(sigName);
                                assignedSignalsProc.add(sigName);
                                continue;
                            }
                            if (!statProc.is(VhdlTree.Kind.VARIABLE_ASSIGNMENT_STATEMENT)) continue;
                            NameTree nameTree = sigName = ((VariableAssignmentStatementTree)statProc).targetName().isName() ? (NameTree)((VariableAssignmentStatementTree)statProc).targetName().target() : null;
                            if (sigName != null && !assignedSignalsProc.contains(sigName) && assignedSignals.contains(sigName)) {
                                this.addPreciseIssue(stat.firstToken(), "Multiple concurrent assignments of the variable " + sigName.firstToken().text() + ".");
                            }
                            assignedSignals.add(sigName);
                            assignedSignalsProc.add(sigName);
                        }
                        assignedSignalsAllProcs.addAll(assignedSignalsProc);
                        break;
                    }
                }
            }
        }
    }
}

