/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.linty.language.checks.FreeHdlDesignerCheck;
import com.lintyservices.sonar.plugins.linty.language.trees.Tree;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ReturnStatementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SubprogramBodyTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SubprogramSpecificationFunctionTree;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.check.Rule;

@Rule(key="VHDL170")
public class MultipleReturnsCheck
extends VhdlDoubleDispatchVisitorCheck
implements FreeHdlDesignerCheck {
    private final List<ReturnStatementTree> returns = new ArrayList<ReturnStatementTree>();

    @Override
    public void visitSubprogramBody(SubprogramBodyTree tree) {
        this.returns.clear();
        if (tree.specification().is(VhdlTree.Kind.SUBPROGRAM_SPECIFICATION_FUNCTION)) {
            super.visitSubprogramBody(tree);
            if (this.returns.size() > 1) {
                this.addPreciseIssue(((SubprogramSpecificationFunctionTree)tree.specification()).functionKeyword(), "Refactor to only keep one \"return\" statement.", this.returns.stream().map(r -> new HdlIssueLocation((Tree)r, "return")).collect(Collectors.toList()));
            }
        }
    }

    @Override
    public void visitReturnStatement(ReturnStatementTree tree) {
        this.returns.add(tree);
        super.visitReturnStatement(tree);
    }
}

