/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.parser.DesignFileTree;
import com.lintyservices.sonar.plugins.vhdl.parser.PackageDeclarationTree;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="VHDL152")
public class NestedPackageCheck
extends VhdlDoubleDispatchVisitorCheck
implements HdlDesignerCheck {
    private static final int DEFAULT_MAX_NESTED_LEVELS = 1;
    private Deque<VhdlTree> packages;
    private String issueMessage;
    @RuleProperty(key="maxNestedLevels", description="The maximum number of authorized nested levels. Set to '0' to disallow nested packages, '1' to allow one nested level and so on.", defaultValue="1")
    public int maxNestedLevels = 1;

    @Override
    public void visitDesignFile(DesignFileTree tree) {
        this.issueMessage = this.computeIssueMessage();
        this.packages = new ArrayDeque<VhdlTree>();
        super.visitDesignFile(tree);
    }

    @Override
    public void visitPackageDeclaration(PackageDeclarationTree tree) {
        this.checkNesting(tree);
        this.packages.push(tree.beginPackageKeyword());
        super.visitPackageDeclaration(tree);
        this.packages.pop();
    }

    private void checkNesting(PackageDeclarationTree tree) {
        int depth = this.packages.size();
        if (depth > this.maxNestedLevels) {
            ArrayList<HdlIssueLocation> secondary = new ArrayList<HdlIssueLocation>(depth);
            for (VhdlTree pkg : this.packages) {
                secondary.add(new HdlIssueLocation(pkg, "Package involved in too deeply nesting"));
            }
            this.addPreciseIssue(tree.beginPackageKeyword(), this.issueMessage, secondary);
        }
    }

    private String computeIssueMessage() {
        StringBuilder message = new StringBuilder("Refactor this code to not nest ");
        if (this.maxNestedLevels == 0) {
            message.append("any package");
        } else {
            message.append("more than ").append(this.maxNestedLevels).append(" package").append(this.maxNestedLevels != 1 ? "s" : "");
        }
        message.append(".");
        return message.toString();
    }
}

