/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Range;
import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlSubscriptionVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlSyntaxToken;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.measures.visitors.Comment;
import com.lintyservices.sonar.plugins.vhdl.measures.visitors.CommentLinesVisitor;
import com.lintyservices.sonar.plugins.vhdl.parser.AliasDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.AttributeDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ConstantDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SignalDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SubtypeDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.TypeDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.VariableDeclarationTree;
import com.lintyservices.utils.LintyException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;

@Rule(key="VHDL160")
public class NoCommentDeclarationCheck
extends VhdlSubscriptionVisitorCheck
implements HdlDesignerCheck {
    private List<Comment> comments;

    @Override
    public Set<VhdlTree.Kind> nodesToVisit() {
        return Set.of(VhdlTree.Kind.SIGNAL_DECLARATION, VhdlTree.Kind.CONSTANT_DECLARATION, VhdlTree.Kind.FULL_TYPE_DECLARATION, VhdlTree.Kind.INCOMPLETE_TYPE_DECLARATION, VhdlTree.Kind.SUBTYPE_DECLARATION, VhdlTree.Kind.ALIAS_DECLARATION, VhdlTree.Kind.ATTRIBUTE_DECLARATION, VhdlTree.Kind.VARIABLE_DECLARATION);
    }

    @Override
    public void visitFile(VhdlTree tree) {
        this.comments = new CommentLinesVisitor(tree).getComments();
        super.visitFile(tree);
    }

    @Override
    public void visitNode(VhdlTree tree) {
        this.checkForIssues(tree);
        super.visitNode(tree);
    }

    private void checkForIssues(VhdlTree declaration) {
        if (!this.trailingCommentFound(declaration) && !this.commentOnPreviousLineFound(declaration)) {
            this.reportIssue(declaration);
        }
    }

    private boolean trailingCommentFound(VhdlTree declaration) {
        ContiguousSet<Integer> declarationLines = ContiguousSet.create(Range.closed(declaration.firstToken().line(), declaration.lastToken().endLine()), DiscreteDomain.integers());
        for (Comment comment : this.comments) {
            if (comment.isBlank()) continue;
            Iterator iterator2 = declarationLines.iterator();
            while (iterator2.hasNext()) {
                int declarationLine = (Integer)iterator2.next();
                if (!comment.getLineNumbers().contains(declarationLine)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean commentOnPreviousLineFound(VhdlTree declaration) {
        for (Comment comment : this.comments) {
            if (comment.isBlank() || comment.isTrailing() || !comment.getLineNumbers().contains(declaration.firstToken().line() - 1)) continue;
            return true;
        }
        return false;
    }

    private void reportIssue(VhdlTree declaration) {
        VhdlSyntaxToken treeToHighlight;
        if (declaration.is(VhdlTree.Kind.SIGNAL_DECLARATION)) {
            treeToHighlight = ((SignalDeclarationTree)declaration).signalKeyword();
        } else if (declaration.is(VhdlTree.Kind.CONSTANT_DECLARATION)) {
            treeToHighlight = ((ConstantDeclarationTree)declaration).constantKeyword();
        } else if (declaration.isOneOf(VhdlTree.Kind.FULL_TYPE_DECLARATION, VhdlTree.Kind.INCOMPLETE_TYPE_DECLARATION)) {
            treeToHighlight = ((TypeDeclarationTree)declaration).typeKeyword();
        } else if (declaration.is(VhdlTree.Kind.SUBTYPE_DECLARATION)) {
            treeToHighlight = ((SubtypeDeclarationTree)declaration).subtypeKeyword();
        } else if (declaration.is(VhdlTree.Kind.ALIAS_DECLARATION)) {
            treeToHighlight = ((AliasDeclarationTree)declaration).aliasKeyword();
        } else if (declaration.is(VhdlTree.Kind.ATTRIBUTE_DECLARATION)) {
            treeToHighlight = ((AttributeDeclarationTree)declaration).attributeKeyword();
        } else if (declaration.is(VhdlTree.Kind.VARIABLE_DECLARATION)) {
            treeToHighlight = ((VariableDeclarationTree)declaration).variableKeyword();
        } else {
            throw new LintyException("Unexpected declaration kind: " + declaration.kind().name());
        }
        this.addPreciseIssue(treeToHighlight, "Add a comment to this declaration.");
    }
}

