/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.parser.DesignFileTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SubprogramSpecificationFunctionTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SubprogramSpecificationProcedureTree;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="VHDL206")
public class NoFunctionProcedureInSynthesisFileCheck
extends VhdlDoubleDispatchVisitorCheck
implements HdlDesignerCheck {
    public static final boolean DEFAULT_ALLOWED_USAGE_IN_PACKAGES = false;
    @RuleProperty(key="allowedUsageInPackages", description="Set to \"true\" to allow usage in packages. Set to \"false\" otherwise.", defaultValue="false")
    public boolean allowedUsageInPackages = false;

    @Override
    public void visitDesignFile(DesignFileTree tree) {
        if (this.context().isSynthesisFile()) {
            super.visitDesignFile(tree);
        }
    }

    @Override
    public void visitFunctionSpecification(SubprogramSpecificationFunctionTree tree) {
        if (!this.allowedUsageInPackages || this.allowedUsageInPackages && !tree.hasAncestor(VhdlTree.Kind.PACKAGE_DECLARATION) && !tree.hasAncestor(VhdlTree.Kind.PACKAGE_BODY)) {
            this.addPreciseIssue(tree.functionKeyword(), "Remove this specification of function.");
        }
        super.visitFunctionSpecification(tree);
    }

    @Override
    public void visitProcedureSpecification(SubprogramSpecificationProcedureTree tree) {
        if (!this.allowedUsageInPackages || this.allowedUsageInPackages && !tree.hasAncestor(VhdlTree.Kind.PACKAGE_DECLARATION) && !tree.hasAncestor(VhdlTree.Kind.PACKAGE_BODY)) {
            this.addPreciseIssue(tree.procedureKeyword(), "Remove this specification of procedure.");
        }
        super.visitProcedureSpecification(tree);
    }
}

