/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.linty.language.checks.FreeHdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.parser.BlockTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ConfigurationDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.DesignFileTree;
import com.lintyservices.sonar.plugins.vhdl.parser.EntityDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.PackageDeclarationTree;
import com.lintyservices.utils.LintyException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.sonar.check.Rule;

@Rule(key="VHDL221")
public class NoMixOfUnitsCheck
extends VhdlDoubleDispatchVisitorCheck
implements FreeHdlDesignerCheck {
    private List<ConfigurationDeclarationTree> configurations;
    private List<EntityDeclarationTree> entities;
    private List<PackageDeclarationTree> packages;

    @Override
    public void visitDesignFile(DesignFileTree tree) {
        ArrayList<BlockTree> units = new ArrayList<BlockTree>();
        this.configurations = new ArrayList<ConfigurationDeclarationTree>();
        this.entities = new ArrayList<EntityDeclarationTree>();
        this.packages = new ArrayList<PackageDeclarationTree>();
        super.visitDesignFile(tree);
        int numberOfDifferentUnits = 0;
        if (!this.configurations.isEmpty()) {
            ++numberOfDifferentUnits;
        }
        if (!this.entities.isEmpty()) {
            ++numberOfDifferentUnits;
        }
        if (!this.packages.isEmpty()) {
            ++numberOfDifferentUnits;
        }
        if (numberOfDifferentUnits > 1) {
            units.addAll(this.configurations);
            units.addAll(this.entities);
            units.addAll(this.packages);
            List<VhdlTree> sortedUnits = units.stream().sorted(Comparator.comparingInt(t -> t.firstToken().line())).toList();
            ArrayList<HdlIssueLocation> secondaryLocations = new ArrayList<HdlIssueLocation>();
            for (int i = 1; i < sortedUnits.size(); ++i) {
                secondaryLocations.add(new HdlIssueLocation(this.getBeginKeyword(sortedUnits.get(i)), "Unit declaration"));
            }
            this.addPreciseIssue(this.getBeginKeyword(sortedUnits.get(0)), "Do not mix entity/package/configuration declarations within the same file.", secondaryLocations);
        }
    }

    @Override
    public void visitEntityDeclaration(EntityDeclarationTree tree) {
        this.entities.add(tree);
        super.visitEntityDeclaration(tree);
    }

    @Override
    public void visitPackageDeclaration(PackageDeclarationTree tree) {
        this.packages.add(tree);
        super.visitPackageDeclaration(tree);
    }

    @Override
    public void visitConfigurationDeclaration(ConfigurationDeclarationTree tree) {
        this.configurations.add(tree);
        super.visitConfigurationDeclaration(tree);
    }

    private VhdlTree getBeginKeyword(VhdlTree tree) {
        if (tree.is(VhdlTree.Kind.CONFIGURATION_DECLARATION)) {
            return ((ConfigurationDeclarationTree)tree).beginConfigurationKeyword();
        }
        if (tree.is(VhdlTree.Kind.ENTITY_DECLARATION)) {
            return ((EntityDeclarationTree)tree).beginEntityKeyword();
        }
        if (tree.is(VhdlTree.Kind.PACKAGE_DECLARATION)) {
            return ((PackageDeclarationTree)tree).beginPackageKeyword();
        }
        throw new LintyException("Unexpected kind for " + String.valueOf(tree));
    }
}

