/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlSyntaxToken;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.lexer.VhdlKeyword;
import com.lintyservices.sonar.plugins.vhdl.model.VhdlInternalSyntaxToken;
import com.lintyservices.sonar.plugins.vhdl.parser.DesignFileTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SubprogramBodyTree;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;

@Rule(key="VHDL183")
public class NonSynthesizableStatementCheck
extends VhdlDoubleDispatchVisitorCheck
implements HdlDesignerCheck {
    public static final Set<VhdlKeyword> SIMULATION_STATEMENTS = Set.of(VhdlKeyword.ACCESS, VhdlKeyword.AFTER, VhdlKeyword.DISCONNECT, VhdlKeyword.FILE, VhdlKeyword.WAIT);
    private final Set<String> simulationStatementsAsString = SIMULATION_STATEMENTS.stream().map(VhdlKeyword::getValue).collect(Collectors.toSet());

    @Override
    public void visitDesignFile(DesignFileTree tree) {
        if (this.context().isSynthesisFile()) {
            super.visitDesignFile(tree);
        }
    }

    @Override
    public void visitInternalSyntaxToken(VhdlInternalSyntaxToken token) {
        if (!(!this.simulationStatementsAsString.contains(token.text().toLowerCase()) || token.text().equalsIgnoreCase(VhdlKeyword.FILE.getValue()) && this.hasFunctionAsAncestor(token))) {
            this.addPreciseIssue(token, "Remove this usage of non-synthesizable statement.");
        }
        super.visitInternalSyntaxToken(token);
    }

    private boolean hasFunctionAsAncestor(VhdlSyntaxToken fileToken) {
        VhdlTree ancestor = fileToken.ancestor(VhdlTree.Kind.SUBPROGRAM_BODY);
        if (ancestor != null) {
            return ((SubprogramBodyTree)ancestor).specification().is(VhdlTree.Kind.SUBPROGRAM_SPECIFICATION_FUNCTION);
        }
        return false;
    }
}

