/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.parser.ArchitectureBodyTree;
import com.lintyservices.sonar.plugins.vhdl.parser.DesignFileTree;
import java.util.ArrayList;
import java.util.List;
import org.sonar.check.Rule;

@Rule(key="VHDL019")
public class OneArchitecturePerFileCheck
extends VhdlDoubleDispatchVisitorCheck
implements HdlDesignerCheck {
    private List<ArchitectureBodyTree> architectures;

    @Override
    public void visitDesignFile(DesignFileTree tree) {
        this.architectures = new ArrayList<ArchitectureBodyTree>();
        super.visitDesignFile(tree);
        if (this.architectures.size() > 1) {
            ArrayList<HdlIssueLocation> secondaryLocations = new ArrayList<HdlIssueLocation>();
            for (int i = 1; i < this.architectures.size(); ++i) {
                secondaryLocations.add(new HdlIssueLocation(this.architectures.get(i).beginArchitectureKeyword(), "Architecture declaration"));
            }
            this.addPreciseIssue(this.architectures.get(0).beginArchitectureKeyword(), "Only define one single architecture per file.", secondaryLocations);
        }
    }

    @Override
    public void visitArchitectureBody(ArchitectureBodyTree tree) {
        this.architectures.add(tree);
        super.visitArchitectureBody(tree);
    }
}

