/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.linty.language.checks.FreeHdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.parser.DesignFileTree;
import com.lintyservices.sonar.plugins.vhdl.parser.PackageDeclarationTree;
import java.util.ArrayList;
import java.util.List;
import org.sonar.check.Rule;

@Rule(key="VHDL219")
public class OnePackagePerFileCheck
extends VhdlDoubleDispatchVisitorCheck
implements FreeHdlDesignerCheck {
    private List<PackageDeclarationTree> packages;

    @Override
    public void visitDesignFile(DesignFileTree tree) {
        this.packages = new ArrayList<PackageDeclarationTree>();
        super.visitDesignFile(tree);
        if (this.packages.size() > 1) {
            ArrayList<HdlIssueLocation> secondaryLocations = new ArrayList<HdlIssueLocation>();
            for (int i = 1; i < this.packages.size(); ++i) {
                secondaryLocations.add(new HdlIssueLocation(this.packages.get(i).beginPackageKeyword(), "Package declaration"));
            }
            this.addPreciseIssue(this.packages.get(0).beginPackageKeyword(), "Only define one single package per file.", secondaryLocations);
        }
    }

    @Override
    public void visitPackageDeclaration(PackageDeclarationTree tree) {
        this.packages.add(tree);
        super.visitPackageDeclaration(tree);
    }
}

