/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.parser.IdentifierTree;
import com.lintyservices.sonar.plugins.vhdl.parser.PortClauseTree;
import com.lintyservices.utils.LintyException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="VHDL118")
public class PortNamingConventionCheck
extends VhdlDoubleDispatchVisitorCheck
implements HdlDesignerCheck {
    private static final List<String> PORT_MODES = Arrays.asList(null, "in", "out", "inout", "buffer", "linkage");
    private static final String DEFAULT_FORMAT = "^[a-z]|[a-z]+[a-z0-9_]*[a-z0-9]+$";
    @RuleProperty(key="in", description="Regular expression to match for \"in\" mode ports.\nSee documentation at https://tinyurl.com/y37njdz2 and online regex checker at https://regex101.com", type="REGULAR_EXPRESSION", defaultValue="^[a-z]|[a-z]+[a-z0-9_]*[a-z0-9]+$")
    public String in = "^[a-z]|[a-z]+[a-z0-9_]*[a-z0-9]+$";
    @RuleProperty(key="out", description="Regular expression to match for \"out\" mode ports.\nSee documentation at https://tinyurl.com/y37njdz2 and online regex checker at https://regex101.com", type="REGULAR_EXPRESSION", defaultValue="^[a-z]|[a-z]+[a-z0-9_]*[a-z0-9]+$")
    public String out = "^[a-z]|[a-z]+[a-z0-9_]*[a-z0-9]+$";
    @RuleProperty(key="inout", description="Regular expression to match for \"inout\" mode ports.\nSee documentation at https://tinyurl.com/y37njdz2 and online regex checker at https://regex101.com", type="REGULAR_EXPRESSION", defaultValue="^[a-z]|[a-z]+[a-z0-9_]*[a-z0-9]+$")
    public String inout = "^[a-z]|[a-z]+[a-z0-9_]*[a-z0-9]+$";
    @RuleProperty(key="buffer", description="Regular expression to match for \"buffer\" mode ports.\nSee documentation at https://tinyurl.com/y37njdz2 and online regex checker at https://regex101.com", type="REGULAR_EXPRESSION", defaultValue="^[a-z]|[a-z]+[a-z0-9_]*[a-z0-9]+$")
    public String buffer = "^[a-z]|[a-z]+[a-z0-9_]*[a-z0-9]+$";
    @RuleProperty(key="linkage", description="Regular expression to match for \"linkage\" mode ports.\nSee documentation at https://tinyurl.com/y37njdz2 and online regex checker at https://regex101.com", type="REGULAR_EXPRESSION", defaultValue="^[a-z]|[a-z]+[a-z0-9_]*[a-z0-9]+$")
    public String linkage = "^[a-z]|[a-z]+[a-z0-9_]*[a-z0-9]+$";
    @RuleProperty(key="none", description="Regular expression to match for ports with no defined mode.\nSee documentation at https://tinyurl.com/y37njdz2 and online regex checker at https://regex101.com", type="REGULAR_EXPRESSION", defaultValue="^[a-z]|[a-z]+[a-z0-9_]*[a-z0-9]+$")
    public String none = "^[a-z]|[a-z]+[a-z0-9_]*[a-z0-9]+$";

    @Override
    public void visitPortClause(PortClauseTree tree) {
        for (String mode : PORT_MODES) {
            for (IdentifierTree identifier : tree.identifiers(mode != null ? Set.of(mode) : null)) {
                Pattern pattern;
                try {
                    pattern = Pattern.compile((String)this.getClass().getField(mode != null ? mode : "none").get(this), 32);
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    throw new LintyException("Rule vhdl:VHDL118: Unknown \"" + mode + "\" mode", e);
                }
                if (pattern.matcher(identifier.text()).matches()) continue;
                this.addPreciseIssue(identifier, String.format("Rename this port to match the following regular expression: %s", pattern.pattern()));
            }
            super.visitPortClause(tree);
        }
    }
}

