/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.linty.language.checks.FreeHdlDesignerCheck;
import com.lintyservices.sonar.plugins.linty.language.trees.Tree;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.measures.visitors.ComplexityVisitor;
import com.lintyservices.sonar.plugins.vhdl.parser.ProcessStatementPartTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ProcessStatementTree;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="VHDL031")
public class ProcessComplexityCheck
extends VhdlDoubleDispatchVisitorCheck
implements FreeHdlDesignerCheck {
    private static final int DEFAULT_MAX = 10;
    @RuleProperty(key="Threshold", description="The maximum authorized complexity for processes.", defaultValue="10")
    public int max = 10;

    @Override
    public void visitProcessStatementPart(ProcessStatementPartTree tree) {
        List<VhdlTree> complexityNodes = new ComplexityVisitor(tree).getComplexityNodes();
        if (complexityNodes.size() > this.max) {
            this.addPreciseIssue(((ProcessStatementTree)tree.ancestor(VhdlTree.Kind.PROCESS_STATEMENT)).beginStatementKeyword(), String.format("Refactor this process to make it simpler to understand. Actual complexity (%d) is greater than the maximum authorized complexity (%d).", complexityNodes.size(), this.max), complexityNodes.stream().map(n -> new HdlIssueLocation((Tree)n, "+1")).toList());
        }
    }
}

