/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.linty.language.checks.FreeHdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.lexer.VhdlKeyword;
import com.lintyservices.sonar.plugins.vhdl.model.VhdlInternalSyntaxToken;
import com.lintyservices.sonar.plugins.vhdl.parser.DesignFileTree;
import com.lintyservices.utils.LintyException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="VHDL185")
public class ReservedWordCaseCheck
extends VhdlDoubleDispatchVisitorCheck
implements FreeHdlDesignerCheck {
    private static final String LOWERCASE = "lowercase";
    private static final String UPPERCASE = "uppercase";
    private static final Set<String> reservedWords = Arrays.stream(VhdlKeyword.values()).map(VhdlKeyword::getValue).collect(Collectors.toSet());
    private Set<String> exceptionsAsSet = new HashSet<String>();
    @RuleProperty(key="reservedWordCase", description="Case of the reserved words. Either 'lowercase' or 'uppercase'.", defaultValue="lowercase")
    public String reservedWordCase = "lowercase";
    @RuleProperty(key="exceptions", description="Comma-separated list of reserved words that should be written in the opposite case (NULL for instance).")
    public String exceptions = "";

    @Override
    public void visitDesignFile(DesignFileTree tree) {
        this.exceptionsAsSet = Arrays.stream(this.exceptions.split(",")).map(e -> e.trim().toLowerCase()).collect(Collectors.toSet());
        super.visitDesignFile(tree);
    }

    @Override
    public void visitInternalSyntaxToken(VhdlInternalSyntaxToken token) {
        if (reservedWords.contains(token.text().toLowerCase())) {
            if (this.exceptionsAsSet.contains(token.text().toLowerCase())) {
                String expectedCase;
                String expectedToken = UPPERCASE.equals(this.reservedWordCase) ? token.text().toLowerCase() : token.text().toUpperCase();
                String string = expectedCase = UPPERCASE.equals(this.reservedWordCase) ? LOWERCASE : UPPERCASE;
                if (!expectedToken.equals(token.text())) {
                    this.addPreciseIssue(token, "This reserved word is an exception. It must be written with " + expectedCase + " characters only.");
                }
            } else {
                String expectedToken;
                String string = expectedToken = UPPERCASE.equals(this.reservedWordCase) ? token.text().toUpperCase() : token.text().toLowerCase();
                if (!expectedToken.equals(token.text())) {
                    this.addPreciseIssue(token, "Update this reserved word to only use " + this.reservedWordCase + " characters.");
                }
            }
        }
        super.visitInternalSyntaxToken(token);
    }

    @Override
    public void validateCheckParameters() {
        if (!Arrays.asList(LOWERCASE, UPPERCASE).contains(this.reservedWordCase)) {
            throw new LintyException(ReservedWordCaseCheck.paramsErrorMessage(this.getClass(), "reservedWordCase parameter is not valid.\nActual: '" + this.reservedWordCase + "'\nExpected: 'lowercase' or 'uppercase'"));
        }
    }
}

