/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.parser.DesignFileTree;
import com.lintyservices.sonar.plugins.vhdl.parser.RelationExpressionTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SignalDeclarationTree;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="VHDL032")
public class SignalInitializedOnDeclarationCheck
extends VhdlDoubleDispatchVisitorCheck
implements HdlDesignerCheck {
    private static final String DEFAULT_ALLOW_SIGNAL_INITIALIZATION_THROUGH_FUNCTION = "false";
    @RuleProperty(key="allowSignalInitializationThroughFunction", description="Set to 'true' to allow signal initialization through function, set to 'false' otherwise.", type="BOOLEAN", defaultValue="false")
    public String allowSignalInitializationThroughFunction = "false";

    @Override
    public void visitDesignFile(DesignFileTree tree) {
        if (this.context().isSynthesisFile()) {
            super.visitDesignFile(tree);
        }
    }

    @Override
    public void visitSignalDeclaration(SignalDeclarationTree tree) {
        if (tree.expression() != null) {
            if (Boolean.parseBoolean(this.allowSignalInitializationThroughFunction)) {
                if (!tree.expression().is(VhdlTree.Kind.RELATION_EXPRESSION) || !((RelationExpressionTree)tree.expression()).shiftExpression1().toString().matches("^[a-zA-Z0-9_]+\\(.+\\)$")) {
                    this.addIssue(tree);
                }
            } else {
                this.addIssue(tree);
            }
        }
        super.visitSignalDeclaration(tree);
    }

    private void addIssue(SignalDeclarationTree tree) {
        this.addPreciseIssue(tree.expression(), "Remove this signal initialization.");
    }
}

