/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.parser.IdentifierTree;
import com.lintyservices.sonar.plugins.vhdl.parser.LibraryClauseTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SelectedNameTree;
import com.lintyservices.sonar.plugins.vhdl.parser.UseClauseTree;
import java.util.Set;
import org.sonar.check.Rule;

@Rule(key="VHDL311")
public class StdAndWorkLibraryCheck
extends VhdlDoubleDispatchVisitorCheck
implements HdlDesignerCheck {
    private static final Set<String> STANDARD_LIBRARIES = Set.of("std", "work");

    @Override
    public void visitLibraryClause(LibraryClauseTree tree) {
        for (IdentifierTree identifier : tree.identifiers()) {
            STANDARD_LIBRARIES.stream().filter(l -> identifier.text().toLowerCase().contains((CharSequence)l)).forEach(l -> this.addPreciseIssue(identifier, "Remove this useless library clause."));
        }
        super.visitLibraryClause(tree);
    }

    @Override
    public void visitUseClause(UseClauseTree tree) {
        for (SelectedNameTree library : tree.libraries().list().elements()) {
            if (!library.toString().toLowerCase().contains("std.standard.")) continue;
            this.addPreciseIssue(library, "Remove this useless use clause.");
        }
        super.visitUseClause(tree);
    }
}

