/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.linty.language.checks.FreeHdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.parser.SelectedNameTree;
import com.lintyservices.sonar.plugins.vhdl.parser.UseClauseTree;
import java.util.Set;
import org.sonar.check.Rule;

@Rule(key="VHDL211")
public class SynopsysLibraryCheck
extends VhdlDoubleDispatchVisitorCheck
implements FreeHdlDesignerCheck {
    private static final Set<String> SYNOPSYS_LIBRARIES = Set.of("ieee.std_logic_arith", "ieee.std_logic_signed", "ieee.std_logic_unsigned");

    @Override
    public void visitUseClause(UseClauseTree tree) {
        for (SelectedNameTree library : tree.libraries().list().elements()) {
            SYNOPSYS_LIBRARIES.stream().filter(l -> library.toString().toLowerCase().contains((CharSequence)l)).forEach(l -> this.addPreciseIssue(library, "Remove the usage of this Synopsys library."));
        }
        super.visitUseClause(tree);
    }
}

