/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.linty.language.checks.FreeHdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.measures.visitors.LinesOfCodeVisitor;
import com.lintyservices.sonar.plugins.vhdl.parser.DesignFileTree;
import java.text.MessageFormat;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="VHDL033")
public class TooManyLinesOfCodeInFileCheck
extends VhdlDoubleDispatchVisitorCheck
implements FreeHdlDesignerCheck {
    private static final int DEFAULT_MAXIMUM = 350;
    @RuleProperty(key="Max", description="Maximum number of lines of code in a file.", defaultValue="350")
    public int max = 350;

    @Override
    public void visitDesignFile(DesignFileTree tree) {
        int lines = new LinesOfCodeVisitor(tree).getNumberOfLinesOfCode();
        if (lines > this.max) {
            this.addFileIssue(MessageFormat.format("This file has {0} lines of code, which is greater than {1} authorized. Split it into smaller files.", lines, this.max));
        }
        super.visitDesignFile(tree);
    }
}

