/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.measures.visitors.LinesOfCodeVisitor;
import com.lintyservices.sonar.plugins.vhdl.parser.ProcessStatementPartTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ProcessStatementTree;
import java.text.MessageFormat;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="VHDL227")
public class TooManyLinesOfCodeInProcessCheck
extends VhdlDoubleDispatchVisitorCheck
implements HdlDesignerCheck {
    private static final int DEFAULT_MAXIMUM = 100;
    @RuleProperty(key="max", description="Maximum number of lines of code in a process.", defaultValue="100")
    public int max = 100;

    @Override
    public void visitProcessStatementPart(ProcessStatementPartTree tree) {
        int lines = new LinesOfCodeVisitor(tree).getNumberOfLinesOfCode();
        if (lines > this.max) {
            this.addPreciseIssue(((ProcessStatementTree)tree.ancestor(VhdlTree.Kind.PROCESS_STATEMENT)).beginStatementKeyword(), MessageFormat.format("This process has {0} lines of code, which is greater than {1} authorized. Split it into smaller processes.", lines, this.max));
        }
        super.visitProcessStatementPart(tree);
    }
}

