/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ArchitectureBodyTree;
import com.lintyservices.sonar.plugins.vhdl.parser.IdentifierTree;
import com.lintyservices.sonar.plugins.vhdl.parser.MultipleDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ProcessStatementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SubprogramBodyTree;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.check.Rule;

@Rule(key="VHDL134")
public class UnusedDeclarationCheck
extends VhdlDoubleDispatchVisitorCheck
implements HdlDesignerCheck {
    @Override
    public void visitArchitectureBody(ArchitectureBodyTree tree) {
        this.checkDeclarationsUsage(tree, tree.declarativePart().blockDeclarativeItems());
        super.visitArchitectureBody(tree);
    }

    @Override
    public void visitSubprogramBody(SubprogramBodyTree tree) {
        this.checkDeclarationsUsage(tree, tree.declarativePart());
        super.visitSubprogramBody(tree);
    }

    @Override
    public void visitProcessStatement(ProcessStatementTree tree) {
        this.checkDeclarationsUsage(tree, tree.declarativePart() != null ? tree.declarativePart().items() : null);
        super.visitProcessStatement(tree);
    }

    private void checkDeclarationsUsage(VhdlTree topTree, @Nullable List<? extends VhdlTree> declarations) {
        if (declarations != null) {
            for (IdentifierTree unusedDeclaredIdentifier : this.unusedDeclaredIdentifiers(this.usedStrings(topTree), this.declaredIdentifiers(declarations))) {
                this.addIssue(unusedDeclaredIdentifier);
            }
        }
    }

    private Set<IdentifierTree> unusedDeclaredIdentifiers(Set<String> usedStrings, Set<IdentifierTree> declaredIdentifiers) {
        return declaredIdentifiers.stream().filter(i -> !usedStrings.contains(i.text().toLowerCase())).collect(Collectors.toSet());
    }

    private Set<IdentifierTree> declaredIdentifiers(List<? extends VhdlTree> declarations) {
        return declarations.stream().filter(d -> d.isOneOf(VhdlTree.Kind.SIGNAL_DECLARATION, VhdlTree.Kind.CONSTANT_DECLARATION, VhdlTree.Kind.VARIABLE_DECLARATION)).map(d -> ((MultipleDeclarationTree)d).identifiers()).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private Set<String> usedStrings(VhdlTree tree) {
        return tree.allChildren(Set.of(VhdlTree.Kind.SIMPLE_NAME), Set.of(VhdlTree.Kind.FORMAL_PART)).stream().map(t -> t.firstToken().text().toLowerCase()).collect(Collectors.toSet());
    }

    private void addIssue(IdentifierTree tree) {
        this.addPreciseIssue(tree, "Remove this unused declaration.");
    }
}

