/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.hdl.visitors.CrossFileCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.PackageBodyTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.PackageTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.TreeFileComparator;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.treefile.PackageBodyTreeFileAwareVisitor;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.treefile.PackageTreeFileAwareVisitor;
import com.lintyservices.sonar.plugins.vhdl.parser.ConstantDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.IdentifierTree;
import com.lintyservices.sonar.plugins.vhdl.parser.MultipleDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.PackageBodyTree;
import com.lintyservices.sonar.plugins.vhdl.parser.PackageDeclarationTree;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.check.Rule;

@Rule(key="VHDL155")
public class UnusedDeferredConstantCheck
extends VhdlDoubleDispatchVisitorCheck
implements CrossFileCheck,
PackageTreeFileAwareVisitor,
PackageBodyTreeFileAwareVisitor {
    private Map<String, Set<PackageTreeFile>> packages = new HashMap<String, Set<PackageTreeFile>>();
    private Set<PackageBodyTreeFile> packageBodies = new HashSet<PackageBodyTreeFile>();

    @Override
    public void setPackages(Set<PackageTreeFile> packages) {
        this.packages = packages.stream().collect(Collectors.groupingBy(t -> ((PackageDeclarationTree)t.tree()).identifier().text(), Collectors.toSet()));
    }

    @Override
    public void setPackageBodies(Set<PackageBodyTreeFile> packageBodies) {
        this.packageBodies = packageBodies;
    }

    @Override
    public final void checkForIssues() {
        for (PackageBodyTreeFile packageBodyTreeFile : this.packageBodies) {
            PackageTreeFile relatedPackage = this.getRelatedPackage(((PackageBodyTree)packageBodyTreeFile.tree()).identifier().text());
            if (relatedPackage == null) continue;
            Set<String> initializedConstantNames = this.getInitializedConstantNames((PackageBodyTree)packageBodyTreeFile.tree());
            for (ConstantDeclarationTree constantDeclaration : ((PackageDeclarationTree)relatedPackage.tree()).deferredConstants()) {
                for (IdentifierTree identifier : constantDeclaration.identifiers()) {
                    if (initializedConstantNames.contains(identifier.text())) continue;
                    this.addPreciseIssue(relatedPackage.file(), identifier, "Set this deferred constant in package body.", List.of(new HdlIssueLocation(packageBodyTreeFile.file(), ((PackageBodyTree)packageBodyTreeFile.tree()).packageKeyword(), "Related package body")));
                }
            }
        }
    }

    @Nullable
    private PackageTreeFile getRelatedPackage(String packageBodyName) {
        if (this.packages.get(packageBodyName) != null) {
            return this.packages.get(packageBodyName).stream().min(new TreeFileComparator()).orElse(null);
        }
        return null;
    }

    private Set<String> getInitializedConstantNames(PackageBodyTree tree) {
        return tree.initializedConstants().stream().map(MultipleDeclarationTree::identifiers).flatMap(Collection::stream).map(IdentifierTree::text).collect(Collectors.toSet());
    }
}

