/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.parser.IdentifierTree;
import com.lintyservices.sonar.plugins.vhdl.parser.MultipleDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SubprogramBodyTree;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;

@Rule(key="VHDL135")
public class UnusedParameterCheck
extends VhdlDoubleDispatchVisitorCheck
implements HdlDesignerCheck {
    @Override
    public void visitSubprogramBody(SubprogramBodyTree tree) {
        if (tree.specification() != null && tree.specification().parameters() != null) {
            List parameters = tree.specification().parameters().interfaces().stream().map(MultipleDeclarationTree::identifiers).flatMap(Collection::stream).toList();
            Set used = tree.allChildren(Set.of(VhdlTree.Kind.SIMPLE_NAME), Set.of(VhdlTree.Kind.FORMAL_PART)).stream().map(t -> t.firstToken().text()).collect(Collectors.toSet());
            for (IdentifierTree parameter : parameters) {
                if (used.contains(parameter.text())) continue;
                this.addPreciseIssue(parameter, "Remove this unused parameter.");
            }
        }
        super.visitSubprogramBody(tree);
    }
}

