/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.linty.language.checks.FreeHdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.parser.DesignFileTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SubprogramBodyTree;
import com.lintyservices.sonar.plugins.vhdl.parser.VariableDeclarationTree;
import org.sonar.check.Rule;

@Rule(key="VHDL190")
public class VariableDeclarationScopeCheck
extends VhdlDoubleDispatchVisitorCheck
implements FreeHdlDesignerCheck {
    @Override
    public void visitDesignFile(DesignFileTree tree) {
        if (this.context().isSynthesisFile()) {
            super.visitDesignFile(tree);
        }
    }

    @Override
    public void visitVariableDeclaration(VariableDeclarationTree tree) {
        if (!this.hasProcessAsAncestor(tree) && !this.hasFunctionOrProcedureAsAncestor(tree)) {
            this.addPreciseIssue(tree, "Remove this variable declaration.");
        }
        super.visitVariableDeclaration(tree);
    }

    private boolean hasFunctionOrProcedureAsAncestor(VariableDeclarationTree tree) {
        return tree.hasAncestor(VhdlTree.Kind.SUBPROGRAM_BODY) && (((SubprogramBodyTree)tree.ancestor(VhdlTree.Kind.SUBPROGRAM_BODY)).specification().is(VhdlTree.Kind.SUBPROGRAM_SPECIFICATION_FUNCTION) || ((SubprogramBodyTree)tree.ancestor(VhdlTree.Kind.SUBPROGRAM_BODY)).specification().is(VhdlTree.Kind.SUBPROGRAM_SPECIFICATION_PROCEDURE));
    }

    private boolean hasProcessAsAncestor(VariableDeclarationTree tree) {
        return tree.hasAncestor(VhdlTree.Kind.PROCESS_DECLARATIVE_PART);
    }
}

