/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.check;

import com.lintyservices.sonar.plugins.vhdl.api.tree.SyntaxTrivia;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public abstract class CommentContainsPatternCheck
extends VhdlDoubleDispatchVisitorCheck {
    private final List<String> patterns;
    private final String message;

    protected CommentContainsPatternCheck(List<String> patterns, String message) {
        this.patterns = patterns;
        this.message = message;
    }

    @Override
    public void visitInternalSyntaxTrivia(SyntaxTrivia trivia) {
        String comment = trivia.text();
        for (String pattern : this.patterns) {
            if (!StringUtils.containsIgnoreCase(comment, pattern) || CommentContainsPatternCheck.isLetterAround(comment, pattern)) continue;
            this.addPreciseIssue(trivia, this.message);
        }
    }

    private static boolean isLetterAround(String line, String pattern) {
        int start = StringUtils.indexOfIgnoreCase(line, pattern);
        int end = start + pattern.length();
        boolean pre = start > 0 && Character.isLetter(line.charAt(start - 1));
        boolean post = end < line.length() - 1 && Character.isLetter(line.charAt(end));
        return pre || post;
    }
}

