/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.check;

import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.hdl.visitors.CrossFileCheck;
import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.linty.language.issues.interfaces.IssueLocationInterface;
import com.lintyservices.sonar.plugins.linty.language.trees.Tree;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.GenericTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.TreeFileComparator;
import com.lintyservices.sonar.plugins.vhdl.parser.IdentifierTree;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class UniqueTreeCheck
extends VhdlDoubleDispatchVisitorCheck
implements CrossFileCheck,
HdlDesignerCheck {
    private final Map<String, Set<GenericTreeFile<IdentifierTree>>> identifierTreeFileMap = new HashMap<String, Set<GenericTreeFile<IdentifierTree>>>();

    @Override
    public final void checkForIssues() {
        this.identifierTreeFileMap.forEach((key, value) -> {
            if (value.size() > 1) {
                List treesWithSameName = value.stream().sorted(new TreeFileComparator()).collect(Collectors.toList());
                GenericTreeFile firstLocation = (GenericTreeFile)treesWithSameName.get(0);
                treesWithSameName.remove(0);
                this.issues().addPreciseIssue(firstLocation.file(), (Tree)firstLocation.tree(), "Rename with different names.", (List<? extends IssueLocationInterface>)treesWithSameName.stream().map(duplicatedTree -> new HdlIssueLocation(duplicatedTree.file(), (Tree)duplicatedTree.tree(), "Duplicated name")).toList());
            }
        });
    }

    public final void addIdentifierTreeFileToMap(IdentifierTree tree, File file) {
        if (this.identifierTreeFileMap.containsKey(tree.text())) {
            this.identifierTreeFileMap.get(tree.text()).add(new GenericTreeFile<IdentifierTree>(tree, file));
        } else {
            HashSet<GenericTreeFile<IdentifierTree>> set = new HashSet<GenericTreeFile<IdentifierTree>>();
            set.add(new GenericTreeFile<IdentifierTree>(tree, file));
            this.identifierTreeFileMap.put(tree.text(), set);
        }
    }
}

