/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.treefile;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;

public class Node<T> {
    private T data;
    private final Set<Node<T>> children = new HashSet<Node<T>>();
    private Node<T> parent = null;

    public Node(T data) {
        this.data = data;
    }

    public void addChild(Node<T> child) {
        child.setParent(this);
        this.children.add(child);
    }

    public void addChildren(Set<Node<T>> children) {
        children.forEach(each -> each.setParent(this));
        this.children.addAll(children);
    }

    public Set<Node<T>> getChildren() {
        return this.children;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    private void setParent(Node<T> parent) {
        this.parent = parent;
    }

    public Node<T> getParent() {
        return this.parent;
    }

    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    public Stack<Node<T>> getAncestors() {
        Stack<Node<T>> ancestors = new Stack<Node<T>>();
        this.getAncestors(this, ancestors);
        return ancestors;
    }

    private void getAncestors(Node<T> node, Stack<Node<T>> ancestors) {
        if (node.parent != null) {
            ancestors.push(node.getParent());
            node.getParent().getAncestors(node.getParent(), ancestors);
        }
    }

    public List<Node<T>> getAllChildren() {
        ArrayList<Node<T>> children = new ArrayList<Node<T>>();
        this.getAllChildren(this, children);
        return children;
    }

    private void getAllChildren(Node<T> node, List<Node<T>> children) {
        children.addAll(node.getChildren());
        node.getChildren().forEach(c -> this.getAllChildren((Node<T>)c, children));
    }

    public List<Node<T>> getAllLeaves() {
        return this.getAllChildren().stream().filter(Node::isLeaf).collect(Collectors.toList());
    }
}

