/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.treefile;

import com.lintyservices.sonar.plugins.vhdl.api.tree.DoubleDispatchVisitor;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.ArchitectureTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.ComponentInstantiationTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.ComponentTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.ConfigurationTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.ConstantTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.DesignFileTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.EntityTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.FunctionTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.PackageBodyTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.PackageTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.ProcedureTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.ProcessTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.SignalTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.SubtypeTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.TreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.TypeTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.VariableTreeFile;
import com.lintyservices.sonar.plugins.vhdl.parser.ArchitectureBodyTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ComponentDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ComponentInstantiationStatementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ConfigurationDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ConstantDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.DesignFileTree;
import com.lintyservices.sonar.plugins.vhdl.parser.EntityDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.FullTypeDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.PackageBodyTree;
import com.lintyservices.sonar.plugins.vhdl.parser.PackageDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ProcessStatementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SignalDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SubprogramBodyTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SubtypeDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.VariableDeclarationTree;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TreeFileVisitor
extends DoubleDispatchVisitor {
    private final Map<Class<? extends TreeFile>, Set<? extends TreeFile>> treeFiles = new HashMap<Class<? extends TreeFile>, Set<? extends TreeFile>>();

    public TreeFileVisitor() {
        Set.of(ArchitectureTreeFile.class, ComponentTreeFile.class, ComponentInstantiationTreeFile.class, ConfigurationTreeFile.class, ConstantTreeFile.class, DesignFileTreeFile.class, EntityTreeFile.class, FunctionTreeFile.class, ProcedureTreeFile.class, PackageBodyTreeFile.class, PackageTreeFile.class, ProcessTreeFile.class, SignalTreeFile.class, SubtypeTreeFile.class, TypeTreeFile.class, VariableTreeFile.class).forEach(c -> this.treeFiles.put((Class<? extends TreeFile>)c, new HashSet()));
    }

    public <U extends TreeFile> Set<U> get(Class<? extends U> clazz) {
        return this.treeFiles.get(clazz);
    }

    @Override
    public void visitArchitectureBody(ArchitectureBodyTree tree) {
        this.get(ArchitectureTreeFile.class).add(new ArchitectureTreeFile(tree, this.context().file()));
        super.visitArchitectureBody(tree);
    }

    @Override
    public void visitComponentDeclaration(ComponentDeclarationTree tree) {
        this.get(ComponentTreeFile.class).add(new ComponentTreeFile(tree, this.context().file()));
        super.visitComponentDeclaration(tree);
    }

    @Override
    public void visitComponentInstantiationStatement(ComponentInstantiationStatementTree tree) {
        this.get(ComponentInstantiationTreeFile.class).add(new ComponentInstantiationTreeFile(tree, this.context().file()));
        super.visitComponentInstantiationStatement(tree);
    }

    @Override
    public void visitConfigurationDeclaration(ConfigurationDeclarationTree tree) {
        this.get(ConfigurationTreeFile.class).add(new ConfigurationTreeFile(tree, this.context().file()));
        super.visitConfigurationDeclaration(tree);
    }

    @Override
    public void visitConstantDeclaration(ConstantDeclarationTree tree) {
        this.get(ConstantTreeFile.class).add(new ConstantTreeFile(tree, this.context().file()));
        super.visitConstantDeclaration(tree);
    }

    @Override
    public void visitDesignFile(DesignFileTree tree) {
        this.get(DesignFileTreeFile.class).add(new DesignFileTreeFile(tree, this.context().file()));
        super.visitDesignFile(tree);
    }

    @Override
    public void visitEntityDeclaration(EntityDeclarationTree tree) {
        this.get(EntityTreeFile.class).add(new EntityTreeFile(tree, this.context().file()));
        super.visitEntityDeclaration(tree);
    }

    @Override
    public void visitSubprogramBody(SubprogramBodyTree tree) {
        if (tree.specification().is(VhdlTree.Kind.SUBPROGRAM_SPECIFICATION_FUNCTION)) {
            this.get(FunctionTreeFile.class).add(new FunctionTreeFile(tree, this.context().file()));
        } else if (tree.specification().is(VhdlTree.Kind.SUBPROGRAM_SPECIFICATION_PROCEDURE)) {
            this.get(ProcedureTreeFile.class).add(new ProcedureTreeFile(tree, this.context().file()));
        }
        super.visitSubprogramBody(tree);
    }

    @Override
    public void visitPackageBody(PackageBodyTree tree) {
        this.get(PackageBodyTreeFile.class).add(new PackageBodyTreeFile(tree, this.context().file()));
        super.visitPackageBody(tree);
    }

    @Override
    public void visitPackageDeclaration(PackageDeclarationTree tree) {
        this.get(PackageTreeFile.class).add(new PackageTreeFile(tree, this.context().file()));
        super.visitPackageDeclaration(tree);
    }

    @Override
    public void visitProcessStatement(ProcessStatementTree tree) {
        this.get(ProcessTreeFile.class).add(new ProcessTreeFile(tree, this.context().file()));
        super.visitProcessStatement(tree);
    }

    @Override
    public void visitSignalDeclaration(SignalDeclarationTree tree) {
        this.get(SignalTreeFile.class).add(new SignalTreeFile(tree, this.context().file()));
        super.visitSignalDeclaration(tree);
    }

    @Override
    public void visitSubtypeDeclaration(SubtypeDeclarationTree tree) {
        this.get(SubtypeTreeFile.class).add(new SubtypeTreeFile(tree, this.context().file()));
        super.visitSubtypeDeclaration(tree);
    }

    @Override
    public void visitFullTypeDeclaration(FullTypeDeclarationTree tree) {
        this.get(TypeTreeFile.class).add(new TypeTreeFile(tree, this.context().file()));
        super.visitFullTypeDeclaration(tree);
    }

    @Override
    public void visitVariableDeclaration(VariableDeclarationTree tree) {
        this.get(VariableTreeFile.class).add(new VariableTreeFile(tree, this.context().file()));
        super.visitVariableDeclaration(tree);
    }
}

